/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IFragmentedModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.DynamicUniqueListIterator;
import org.eclipse.emf.diffmerge.impl.scopes.MultiResourceTreeIterator;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.diffmerge.util.structures.HashBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.IModifiableBinaryRelation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentedModelScope
extends AbstractModelScope
implements IFragmentedModelScope {
    protected final List<Resource> _resources = new ArrayList<Resource>();
    protected final List<Resource> _rootResources;
    protected final IModifiableBinaryRelation<Resource, Resource> _includedResources;
    protected final IModifiableBinaryRelation<Resource, Resource> _referencedResources;
    protected boolean _hasBeenFullyExplored;

    public FragmentedModelScope(Resource resource_p) {
        this.addNewResource(resource_p);
        this._rootResources = new ArrayList<Resource>();
        this._rootResources.add(resource_p);
        this._includedResources = new HashBinaryRelation<Resource, Resource>();
        this._referencedResources = new HashBinaryRelation<Resource, Resource>();
        this._hasBeenFullyExplored = false;
    }

    @Override
    public boolean add(EObject element_p) {
        boolean result = false;
        Resource defaultResource = this.getResourceForNewRoot(element_p);
        if (defaultResource != null) {
            defaultResource.getContents().add((Object)element_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        Resource oldResource = value_p.eResource();
        boolean wasRoot = oldResource != null && oldResource.getContents().contains((Object)value_p);
        String formerId = ModelImplUtil.getXmlId(value_p);
        boolean result = super.add(source_p, reference_p, value_p);
        if (wasRoot && reference_p.isContainment()) {
            oldResource.getContents().remove((Object)value_p);
        }
        if (formerId != null) {
            ModelImplUtil.setXmlId(value_p, formerId);
        }
        return result;
    }

    protected void addNewResource(Resource resource_p) {
        this._resources.add(resource_p);
    }

    protected boolean containsUnnecessaryProxies(Collection<EObject> collection_p, EObject source_p) {
        for (EObject current : collection_p) {
            if (!current.eIsProxy() || current == ModelImplUtil.resolveIfLoaded(current, source_p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<EObject> get(EObject source_p, EReference reference_p) {
        List<EObject> result = super.get(source_p, reference_p);
        boolean requiresResolution = this.containsUnnecessaryProxies(result, source_p);
        if (requiresResolution) {
            result = this.get(source_p, reference_p, true);
        }
        return result;
    }

    @Override
    public TreeIterator<EObject> getAllContents() {
        return new ExpandingMultiResourceTreeIterator();
    }

    @Override
    public List<EObject> getContents() {
        FArrayList result = new FArrayList();
        for (Resource resource : this._rootResources) {
            result.addAll(resource.getContents());
        }
        return Collections.unmodifiableList(result);
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        return Collections.emptyList();
    }

    @Override
    public Resource getHoldingResource() {
        return this._rootResources.isEmpty() ? null : this._rootResources.get(0);
    }

    @Override
    public List<Resource> getIncludedResources(Resource resource_p) {
        return this._includedResources.get(resource_p);
    }

    @Override
    public List<Resource> getReferencedResources(Resource resource_p) {
        return this._referencedResources.get(resource_p);
    }

    @Override
    public List<Resource> getRootResources() {
        return Collections.unmodifiableList(this._rootResources);
    }

    protected List<Resource> getRelevantReferencedResources(EObject element_p) {
        FOrderedSet<Resource> result = new FOrderedSet<Resource>();
        Collection<EReference> refsInScope = this.getCrossReferencesInScope(element_p);
        for (EReference ref : refsInScope) {
            if (ref.isContainment() || ref.isContainer() || !element_p.eIsSet((EStructuralFeature)ref)) continue;
            List<EObject> values = this.get(element_p, ref, true);
            for (EObject value : values) {
                Resource valueResource = value.eResource();
                if (valueResource == null) continue;
                result.add(valueResource);
            }
        }
        return result;
    }

    protected Resource getResourceForNewRoot(EObject newRoot_p) {
        for (Resource resource : this._resources) {
            if (!this.isSuitableFor(resource, newRoot_p)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public List<Resource> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    public boolean hasBeenExplored() {
        return this._hasBeenFullyExplored;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        return true;
    }

    @Override
    public boolean load() throws Exception {
        for (Resource rootResource : this._rootResources) {
            rootResource.load(null);
        }
        return true;
    }

    protected final void notifyInclusion(Resource resource_p, EObject element_p) {
        Resource containerResource;
        EObject container;
        if (!this._resources.contains(resource_p)) {
            this.addNewResource(resource_p);
        }
        if ((container = this.getContainer(element_p)) != null && (containerResource = container.eResource()) != null && containerResource != resource_p) {
            this._includedResources.add(containerResource, resource_p);
            this._rootResources.remove(resource_p);
            this._referencedResources.remove(containerResource, resource_p);
        }
    }

    protected final void notifyReference(Resource source_p, Resource target_p) {
        if (!this._resources.contains(target_p)) {
            this.addNewResource(target_p);
            this._rootResources.add(target_p);
            this._referencedResources.add(source_p, target_p);
        }
    }

    @Override
    public boolean save() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        for (Resource resource : this.getResources()) {
            resource.save(options);
        }
        return true;
    }

    class ExpandingMultiResourceTreeIterator
    extends MultiResourceTreeIterator {
        public ExpandingMultiResourceTreeIterator() {
            super(new DynamicUniqueListIterator<Resource>(FragmentedModelScope.this._resources));
        }

        public EObject next() {
            EObject result = super.next();
            if (!FragmentedModelScope.this._hasBeenFullyExplored) {
                Resource resource = result.eResource();
                if (resource != null) {
                    FragmentedModelScope.this.notifyInclusion(resource, result);
                }
                for (Resource additionalResource : FragmentedModelScope.this.getRelevantReferencedResources(result)) {
                    FragmentedModelScope.this.notifyReference(resource, additionalResource);
                }
                if (!this.hasNext()) {
                    FragmentedModelScope.this._hasBeenFullyExplored = true;
                }
            }
            return result;
        }
    }
}

