/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sqlite.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCColumn;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SQLiteTableColumnLoader
extends JDBCTableColumnLoader {
    public SQLiteTableColumnLoader() {
        super(null, null);
    }

    protected Column processRow(ResultSet rs) throws SQLException {
        String nulls;
        JDBCColumn column = new JDBCColumn();
        String columnName = rs.getString(4);
        column.setName(columnName);
        String remarks = rs.getString(12);
        column.setDescription(remarks);
        String defaultValue = rs.getString(13);
        column.setDefaultValue(defaultValue);
        String typeName = rs.getString(6);
        DatabaseDefinition databaseDefinition = this.getDatabaseDefinition();
        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
        if (typeDefinition != null) {
            EStructuralFeature feature;
            PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
            if (typeDefinition.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                type.eSet(feature, (Object)new Integer(rs.getInt(7)));
            } else if (typeDefinition.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                type.eSet(feature, (Object)new Integer(rs.getInt(10)));
            }
            if (typeDefinition.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                type.eSet(feature, (Object)new Integer(rs.getInt(9)));
            }
            column.setContainedType((SQLDataType)type);
        }
        if ((nulls = rs.getString(18)).equals("YES")) {
            column.setNullable(true);
        } else {
            column.setNullable(false);
        }
        return column;
    }
}

