/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.actions;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function.FunctionBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionElement;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;

public class DeleteFunctionParameterAction
extends Action {
    TableViewer tableViewer;
    WizardPage wp;

    public DeleteFunctionParameterAction(TableViewer tableViewer, WizardPage wp) {
        super(Messages._UI_ACTION_DELETE_PARAMETER);
        this.tableViewer = tableViewer;
        this.wp = wp;
    }

    public void run() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection es = (IStructuredSelection)selection;
        Iterator elements = es.iterator();
        FunctionBuilderPage page = (FunctionBuilderPage)this.wp;
        this.tableViewer.cancelEditing();
        if (es.size() == 1) {
            Object item = elements.next();
            if (item instanceof ExpressionElement) {
                ExpressionElement element = (ExpressionElement)item;
                Vector elementsVector = element.getElementsVector();
                ExpressionElement firstElement = null;
                if (elementsVector != null && !elementsVector.isEmpty()) {
                    firstElement = (ExpressionElement)elementsVector.get(0);
                }
                element.deleteExpression();
                int paramNo = element.getParameterNum();
                QueryValueExpression expr = null;
                QueryValueExpression root = null;
                expr = firstElement.getExpression();
                if (expr != null) {
                    root = ExpressionHelper.getRoot(expr);
                }
                page.setParamValue(paramNo, root);
            }
        } else {
            TreeSet<ExpressionElement> treeSet = new TreeSet<ExpressionElement>();
            while (elements.hasNext()) {
                Object item = elements.next();
                if (!(item instanceof ExpressionElement)) continue;
                ExpressionElement element = (ExpressionElement)item;
                element.deleteExpression();
                Vector elementsVector = element.getElementsVector();
                if (element == null || elementsVector.isEmpty()) continue;
                ExpressionElement e = (ExpressionElement)elementsVector.get(0);
                treeSet.add(e);
            }
            for (ExpressionElement element : treeSet) {
                int paramNo = element.getParameterNum();
                QueryValueExpression expr = element.getExpression();
                QueryValueExpression root = null;
                if (expr != null) {
                    root = ExpressionHelper.getRoot(expr);
                }
                page.setParamValue(paramNo, root);
            }
        }
        this.tableViewer.refresh();
        page.updateFinishButton();
    }
}

