/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.sqltools.data.internal.core.common.IColumnDataAccessor;

class ColumnDataAccessorExtension {
    protected IConfigurationElement element;
    protected String vendors;
    protected String versions;
    protected String dataTypes;
    protected int score;

    public ColumnDataAccessorExtension(IConfigurationElement element) {
        this.element = element;
        this.vendors = element.getAttribute("vendor");
        this.versions = element.getAttribute("version");
        this.dataTypes = element.getAttribute("dataType");
        this.score = (this.vendors != null ? 1 : 0) + (this.versions != null ? 1 : 0) + (this.dataTypes != null ? 1 : 0);
    }

    public boolean matches(String vendor, String version, String dataType) {
        if (this.vendors != null && !this.contains(this.vendors, vendor)) {
            return false;
        }
        if (this.versions != null && !this.contains(this.versions, version)) {
            return false;
        }
        return this.dataTypes == null || this.contains(this.dataTypes, dataType);
    }

    protected boolean contains(String values, String value) {
        StringTokenizer st = new StringTokenizer(values, ",", false);
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (!value.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public IColumnDataAccessor createInstance() throws CoreException {
        return (IColumnDataAccessor)this.element.createExecutableExtension("class");
    }

    public int getScore() {
        return this.score;
    }
}

