/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.db2.model.impl.DB2TriggerImpl;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogTrigger
extends DB2TriggerImpl
implements ICatalogObject,
IDatabaseObject {
    private boolean dependencyLoaded = false;

    public void refresh() {
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        this.actionStatement.clear();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return ((ICatalogObject)this.getCatalogDatabase()).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSubjectTable().getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public ICatalogObject[] getImpacted() {
        Collection impacts = this.getImpactedObjects();
        ICatalogObject[] objs = new ICatalogObject[impacts.size()];
        impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 2) {
            this.getDependencies();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTrigger.loadDependencies(this.getConnection(), super.getDependencies(), (Trigger)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadDependencies(Connection connection, EList dependencyList, Trigger trigger) throws SQLException {
        Database database = trigger.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery("SELECT BSCHEMA, BNAME, BTYPE FROM SYSCAT.TRIGDEP WHERE TRIGSCHEMA='" + LUWUtil.getIdentifier(trigger.getSchema().getName()) + "' AND TRIGNAME='" + LUWUtil.getIdentifier(trigger.getName()) + "'");
        try {
            while (r.next()) {
                String bschema = r.getString(1).trim();
                String bname = r.getString(2);
                String btype = r.getString(3);
                Table obj = null;
                if (btype.equals("A")) {
                    obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                } else if (btype.equals("B")) {
                    obj = LUWCatalogTrigger.getTrigger(trigger, bschema, bname);
                } else if (btype.equals("F")) {
                    obj = LUWCatalogTrigger.getRountine(trigger, bschema, bname);
                } else if (btype.equals("N")) {
                    obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                } else {
                    if (btype.equals("O")) continue;
                    if (btype.equals("R")) {
                        obj = LUWCatalogTrigger.getUserDefinedType(trigger, bschema, bname);
                    } else if (btype.equals("S")) {
                        obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                    } else if (btype.equals("T")) {
                        obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                    } else if (btype.equals("U")) {
                        obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                    } else if (btype.equals("V")) {
                        obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                    } else if (btype.equals("W")) {
                        obj = LUWCatalogTrigger.getTable(trigger, bschema, bname);
                    } else {
                        if (!btype.equals("X")) continue;
                        continue;
                    }
                }
                if (obj == null) continue;
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)obj);
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static Schema getSchema(Trigger trigger, String schemaName) {
        Schema s2 = trigger.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database d = s2.getDatabase();
        if (d instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)d).getSchema(schemaName)) != null) {
            return s2;
        }
        for (Schema s2 : d.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(d);
        if (d instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)d).cacheSchema((Schema)schema);
        }
        return schema;
    }

    public static Table getTable(Trigger trigger, String schemaName, String tableName) {
        Table t;
        Schema schema = LUWCatalogTrigger.getSchema(trigger, schemaName);
        if (schema instanceof LUWCatalogSchema && (t = ((LUWCatalogSchema)schema).getTable(schemaName, tableName)) != null) {
            return t;
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static Routine getRountine(Trigger trigger, String schemaName, String specificName) {
        Schema schema = LUWCatalogTrigger.getSchema(trigger, schemaName);
        for (Routine r : schema.getRoutines()) {
            if (!specificName.equals(r.getSpecificName())) continue;
            return r;
        }
        return null;
    }

    public static Trigger getTrigger(Trigger trigger, String schemaName, String triggerName) {
        Schema schema = LUWCatalogTrigger.getSchema(trigger, schemaName);
        for (Trigger r : schema.getTriggers()) {
            if (!r.getName().equals(triggerName)) continue;
            return r;
        }
        return null;
    }

    public static UserDefinedType getUserDefinedType(Trigger trigger, String schemaName, String userDefinedTypeName) {
        Schema schema = LUWCatalogTrigger.getSchema(trigger, schemaName);
        for (UserDefinedType userDefinedType : schema.getUserDefinedTypes()) {
            if (!userDefinedType.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType;
        }
        return null;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogTrigger.getImpactedTriggers(connection, (Trigger)this));
        impacts.addAll(LUWCatalogTrigger.getImpactedPackages(connection, (Trigger)this));
        return impacts;
    }

    protected static Collection getImpactedTriggers(Connection connection, Trigger trigger) {
        ArrayList<Trigger> impacts = new ArrayList<Trigger>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT B.TRIGNAME,B.TABNAME,B.TABSCHEMA FROM SYSCAT.TRIGDEP A, SYSCAT.TRIGGERS B where BTYPE='B' AND A.TRIGSCHEMA = B.TRIGSCHEMA AND A.TRIGNAME = B.TRIGNAME AND A.BNAME='" + LUWUtil.getIdentifier(trigger.getName()) + "'" + " AND A.BSCHEMA='" + LUWUtil.getIdentifier(trigger.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String trigName = r.getString("TRIGNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Trigger trig = LUWCatalogView.getTrigger(trigger.getSubjectTable(), schemaName, tabName, trigName);
                if (trig == null) continue;
                impacts.add(trig);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedPackages(Connection connection, Trigger trigger) {
        ArrayList<DB2Package> impacts = new ArrayList<DB2Package>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT PKGNAME, PKGSCHEMA, HEX(UNIQUE_ID) AS UID FROM SYSCAT.PACKAGEDEP WHERE BTYPE = 'B' AND BNAME='" + LUWUtil.getIdentifier(trigger.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(trigger.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String pkgName = r.getString("PKGNAME").trim();
                String schemaName = r.getString("PKGSCHEMA").trim();
                String pkgUniqueID = r.getString("UID").trim();
                DB2Package pkg = LUWCatalogView.getDb2Package(trigger.getSubjectTable(), schemaName, pkgName, pkgUniqueID);
                if (pkg == null) continue;
                impacts.add(pkg);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }
}

