/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.EObjectListPropertyContentProvider;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.TableColumnsPropertyLabelProvider;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.GenericColumnsComposite;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.actions.AddColumnAction;
import org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.actions.DeleteColumnAction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class GenericColumnsPage
extends WizardPage {
    private static final String COLUMN_PAGE_TITLE_LABEL = "column_page.title.label";
    private static final String COLUMN_PAGE_DESCRIPTION_LABEL = "column_page.description.label";
    private PersistentTable table;
    private Map dataTypeMap = new HashMap();
    private DatabaseDefinition dbDifinition;

    public GenericColumnsPage(String pageName, PersistentTable table) {
        super(pageName);
        this.table = table;
        Database db = this.table.getSchema().getDatabase() != null ? this.table.getSchema().getDatabase() : this.table.getSchema().getCatalog().getDatabase();
        this.dbDifinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
    }

    public void createControl(Composite parent) {
        this.setTitle(ResourceLoader.queryString(COLUMN_PAGE_TITLE_LABEL));
        this.setDescription(ResourceLoader.queryString(COLUMN_PAGE_DESCRIPTION_LABEL));
        GenericColumnsComposite composite = new GenericColumnsComposite(parent, 0);
        this.setControl((Control)composite);
        this.bindTableName(composite);
        this.bindColumns(composite);
        this.bindColumn(composite);
    }

    private void bindColumn(final GenericColumnsComposite composite) {
        final TableViewer columnsViewer = composite.getColumnsTableViewer();
        final ComboViewer dataTypeComboViewer = composite.getDataTypeComboViewer();
        dataTypeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        dataTypeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                DataType dataType = (DataType)element;
                return dataType.getName();
            }
        });
        columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    Column key = (Column)ss.getFirstElement();
                    DataType[] dataTypes = (DataType[])GenericColumnsPage.this.dataTypeMap.get(key);
                    if (dataTypes == null) {
                        dataTypes = GenericColumnsPage.this.computeDataTypes();
                        GenericColumnsPage.this.dataTypeMap.put(key, dataTypes);
                    }
                    dataTypeComboViewer.setInput((Object)dataTypes);
                }
            }
        });
        columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss.isEmpty()) {
                    composite.getColumnNameText().setText("");
                    composite.getDefaultValueText().setText("");
                    composite.getNotNullCheck().setSelection(false);
                    composite.getDataTypeComboViewer().setSelection((ISelection)new StructuredSelection((Object)""));
                    return;
                }
                Column c = (Column)ss.getFirstElement();
                if (c.getName() != null) {
                    composite.getColumnNameText().setText(c.getName());
                }
                if (c.getDefaultValue() != null) {
                    composite.getDefaultValueText().setText(c.getDefaultValue());
                }
                composite.getNotNullCheck().setSelection(c.isNullable());
                if (c.getDataType() != null) {
                    composite.getDataTypeComboViewer().setSelection((ISelection)new StructuredSelection((Object)c.getDataType()));
                }
            }
        });
        composite.getColumnNameText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.getSource();
                IStructuredSelection ss = (IStructuredSelection)columnsViewer.getSelection();
                if (ss.isEmpty()) {
                    return;
                }
                Column c = (Column)ss.getFirstElement();
                c.setName(text.getText());
            }
        });
        composite.getDefaultValueText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.getSource();
                IStructuredSelection ss = (IStructuredSelection)columnsViewer.getSelection();
                if (ss.isEmpty()) {
                    return;
                }
                Column c = (Column)ss.getFirstElement();
                c.setDefaultValue(text.getText());
            }
        });
        composite.getNotNullCheck().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection ss = (IStructuredSelection)columnsViewer.getSelection();
                if (ss.isEmpty()) {
                    return;
                }
                Column c = (Column)ss.getFirstElement();
                Button button = (Button)event.widget;
                c.setNullable(button.getSelection());
            }
        });
        composite.getDataTypeComboViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)columnsViewer.getSelection();
                if (ss.isEmpty()) {
                    return;
                }
                Column c = (Column)ss.getFirstElement();
                IStructuredSelection ss2 = (IStructuredSelection)event.getSelection();
                DataType dataType = (DataType)ss2.getFirstElement();
                c.setDataType(dataType);
            }
        });
        composite.getDataTypeComboViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    DataType dataType = (DataType)ss.getFirstElement();
                    PredefinedDataTypeDefinition predefinedDataTypeDefinition = GenericColumnsPage.this.dbDifinition.getPredefinedDataTypeDefinition(dataType.getName());
                    if (predefinedDataTypeDefinition.isLengthSupported()) {
                        composite.getDataTypeLengthText().setVisible(true);
                        composite.getDataTypeLengthLabel().setVisible(true);
                        composite.getDataTypeLengthText().setText(new Integer(GenericColumnsPage.this.getLength(dataType)).toString());
                        return;
                    }
                }
                composite.getDataTypeLengthText().setVisible(false);
                composite.getDataTypeLengthLabel().setVisible(false);
                composite.getDataTypeLengthText().setText("");
            }
        });
        composite.getDataTypeLengthText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String lengthText = composite.getDataTypeLengthText().getText();
                if (!composite.getDataTypeComboViewer().getSelection().isEmpty() && lengthText.length() > 0) {
                    IStructuredSelection ss = (IStructuredSelection)composite.getDataTypeComboViewer().getSelection();
                    DataType dataType = (DataType)ss.getFirstElement();
                    GenericColumnsPage.this.setLength(dataType, new Integer(lengthText));
                }
            }
        });
        composite.getDataTypeLengthText().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                char c = e.character;
                if (c >= '\"' && (c < '0' || c > '9')) {
                    e.doit = false;
                }
            }
        });
    }

    private void setLength(DataType dataType, int length) {
        try {
            PropertyDescriptor descriptor = this.getLengthPropertyDescriptor(dataType);
            Method writeMethod = descriptor.getWriteMethod();
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke((Object)dataType, new Integer(length));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PropertyDescriptor getLengthPropertyDescriptor(DataType dataType) throws IntrospectionException {
        PropertyDescriptor descriptor = new PropertyDescriptor("length", dataType.getClass());
        return descriptor;
    }

    private int getLength(DataType dataType) {
        try {
            PropertyDescriptor descriptor = this.getLengthPropertyDescriptor(dataType);
            Method readMethod = descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return (Integer)readMethod.invoke((Object)dataType, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public DataType[] computeDataTypes() {
        ArrayList<PredefinedDataType> dataTypeList = new ArrayList<PredefinedDataType>();
        Iterator iter = this.dbDifinition.getPredefinedDataTypes();
        while (iter.hasNext()) {
            PredefinedDataTypeDefinition dataTypeDefinition = (PredefinedDataTypeDefinition)iter.next();
            PredefinedDataType dataType = this.dbDifinition.getPredefinedDataType(dataTypeDefinition);
            dataTypeList.add(dataType);
        }
        return dataTypeList.toArray(new DataType[dataTypeList.size()]);
    }

    private void bindColumns(GenericColumnsComposite composite) {
        TableViewer columnsViewer = composite.getColumnsTableViewer();
        EObjectListPropertyContentProvider columnsContentProvider = new EObjectListPropertyContentProvider(7);
        columnsViewer.setContentProvider((IContentProvider)columnsContentProvider);
        int[] observeChildrenIDs = new int[]{1, 7, 13, 14};
        columnsViewer.setLabelProvider((IBaseLabelProvider)new TableColumnsPropertyLabelProvider((EObject)this.table, 7, observeChildrenIDs));
        EList columnList = this.table.getColumns();
        columnsViewer.setInput((Object)this.table);
        final AddColumnAction addColumnAction = new AddColumnAction((List)columnList, columnsViewer);
        final DeleteColumnAction deleteColumnAction = new DeleteColumnAction((List)columnList, (ISelectionProvider)columnsViewer);
        composite.getAddButton().addSelectionListener((SelectionListener)addColumnAction);
        composite.getDeleteButton().addSelectionListener((SelectionListener)deleteColumnAction);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)addColumnAction);
                manager.add((IAction)deleteColumnAction);
            }
        });
        Menu menu = menuManager.createContextMenu(composite.getColumnsTableViewer().getControl());
        composite.getColumnsTableViewer().getControl().setMenu(menu);
    }

    private void bindTableName(GenericColumnsComposite composite) {
        composite.getTableNameText().setText(this.table.getName());
        composite.getTableNameText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.getSource();
                GenericColumnsPage.this.table.setName(text.getText());
            }
        });
    }
}

