/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tablewizard.ui.utils;

import java.util.List;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.EObjectUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class EObjectListPropertyContentProvider
implements IStructuredContentProvider {
    private Viewer viewer;
    private EObject target;
    private int featureID;
    private Adapter listChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (EObjectListPropertyContentProvider.this.viewer.getControl().isDisposed()) {
                return;
            }
            if (EObjectListPropertyContentProvider.this.featureID != msg.getFeatureID(msg.getNotifier().getClass())) {
                return;
            }
            switch (msg.getEventType()) {
                case 3: {
                    if (EObjectListPropertyContentProvider.this.viewer instanceof AbstractListViewer) {
                        ((AbstractListViewer)EObjectListPropertyContentProvider.this.viewer).add(msg.getNewValue());
                        break;
                    }
                    ((TableViewer)EObjectListPropertyContentProvider.this.viewer).insert(msg.getNewValue(), msg.getPosition());
                    break;
                }
                case 5: {
                    break;
                }
                case 4: {
                    if (EObjectListPropertyContentProvider.this.viewer instanceof AbstractListViewer) {
                        ((AbstractListViewer)EObjectListPropertyContentProvider.this.viewer).remove(msg.getOldValue());
                        break;
                    }
                    ((TableViewer)EObjectListPropertyContentProvider.this.viewer).remove(msg.getOldValue());
                    break;
                }
                case 6: {
                    break;
                }
            }
        }
    };

    public EObjectListPropertyContentProvider(int featureID) {
        this.featureID = featureID;
    }

    public Object[] getElements(Object inputElement) {
        EStructuralFeature feature = EObjectUtils.computeStructualFeature(this.target, this.featureID);
        Object elements = this.target.eGet(feature);
        if (elements instanceof List) {
            return ((List)elements).toArray();
        }
        return new Object[]{elements};
    }

    public void dispose() {
        this.target.eAdapters().remove((Object)this.listChangeListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(viewer instanceof TableViewer) && !(viewer instanceof AbstractListViewer)) {
            throw new IllegalArgumentException("This content provider only works with TableViewer or AbstractListViewer");
        }
        if (newInput != null && !(newInput instanceof EObject)) {
            throw new IllegalArgumentException("This content provider only works with input of type EObject");
        }
        this.setInput((EObject)newInput);
    }

    private void setInput(EObject target) {
        if (target == null) {
            return;
        }
        if (target != null) {
            target.eAdapters().remove((Object)this.listChangeListener);
        }
        this.target = target;
        this.target.eAdapters().add((Object)this.listChangeListener);
    }
}

