/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.externalfile.ExternalSQLFileAnnotationModel;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLUtility;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLStorageAnnotationModel;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;

public class SQLScrapbookDocumentProvider
extends FileDocumentProvider {
    static /* synthetic */ Class class$0;

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = null;
        document = super.createDocument(element);
        if (document == null) {
            document = new Document("");
        }
        if (element instanceof SQLScrapbookEditorInput) {
            ((SQLScrapbookEditorInput)((Object)element)).showMessageConnection();
        }
        return document;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        IEditorPart editor;
        if (element instanceof IFileEditorInput) {
            this.doSaveFileResource(monitor, element, document, overwrite);
        } else if (element instanceof IAdaptable) {
            IPath location;
            ILocationProvider provider;
            IAdaptable adaptable = (IAdaptable)element;
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer fileBuffer = null;
            LocationKind locationKind = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (ILocationProvider)adaptable.getAdapter((Class)clazz)) instanceof ILocationProviderExtension) {
                URI uri = ((ILocationProviderExtension)provider).getURI(element);
                if (ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri).length == 0) {
                    IFileStore fileStore = EFS.getStore((URI)uri);
                    manager.connectFileStore(fileStore, this.getProgressMonitor());
                    fileBuffer = manager.getFileStoreTextFileBuffer(fileStore);
                }
            }
            if (fileBuffer == null && provider != null && (location = provider.getPath(element)) != null) {
                locationKind = LocationKind.NORMALIZE;
                manager.connect(location, locationKind, this.getProgressMonitor());
                fileBuffer = manager.getTextFileBuffer(location, locationKind);
            }
            if (fileBuffer != null) {
                fileBuffer.getDocument().set(document.get());
                fileBuffer.commit(null, true);
            }
        }
        if (element instanceof SQLScrapbookEditorInput) {
            ((SQLScrapbookEditorInput)((Object)element)).showMessageConnection();
        }
        if ((editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)element)) != null && editor instanceof SQLEditor) {
            ((SQLEditor)editor).refreshConnectionStatus();
        }
    }

    private void doSaveFileResource(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        ISQLEditorConnectionInfo connectionInfo;
        ISQLEditorConnectionInfo connectionInfo2;
        IEditorPart editor;
        IDocument storageDocument = null;
        String statementSQL = document.get();
        if (statementSQL == null) {
            statementSQL = "";
        }
        String encodedConnection = null;
        IFile fileResource = null;
        SQLEditor sqlEditor = null;
        if (encodedConnection == null && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)element)) != null && editor instanceof SQLEditor && (connectionInfo2 = (sqlEditor = (SQLEditor)editor).getConnectionInfo()) != null) {
            encodedConnection = connectionInfo2.encode();
        }
        if (element instanceof IFileEditorInput) {
            fileResource = ((IFileEditorInput)element).getFile();
        }
        if (encodedConnection == null && element instanceof SQLScrapbookEditorInput && (connectionInfo = ((SQLScrapbookEditorInput)((Object)element)).getConnectionInfo()) != null) {
            encodedConnection = connectionInfo.encode();
        }
        if (encodedConnection == null && fileResource != null && !"sqlpage".equalsIgnoreCase(fileResource.getFileExtension()) && fileResource.exists()) {
            encodedConnection = SQLFileUtil.getEncodedConnectionInfo(fileResource);
        }
        if (encodedConnection == null) {
            encodedConnection = "";
        }
        if (fileResource != null && "sqlpage".equalsIgnoreCase(fileResource.getFileExtension())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("encodedConnection", encodedConnection);
            String pageXML = SQLUtility.getOutputSQLPageXML(statementSQL, map);
            storageDocument = new Document(pageXML);
        }
        if (encodedConnection != null && fileResource != null && !"sqlpage".equalsIgnoreCase(fileResource.getFileExtension())) {
            SQLFileUtil.setEncodedConnectionInfo(fileResource, encodedConnection);
        }
        if (storageDocument == null) {
            storageDocument = document;
        }
        super.doSaveDocument(monitor, element, storageDocument, overwrite);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof ILocationProvider) {
            return new ExternalSQLFileAnnotationModel(((ILocationProvider)element).getPath(element));
        }
        if (element instanceof SQLEditorStorageEditorInput) {
            return new SQLStorageAnnotationModel((SQLEditorStorage)((SQLEditorStorageEditorInput)element).getStorage());
        }
        return super.createAnnotationModel(element);
    }
}

