/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;

public class SQLFileUtil {
    public static ISQLEditorConnectionInfo getConnectionInfo(IFile file) {
        String encodedConnection = null;
        encodedConnection = SQLFileUtil.getEncodedConnectionInfo(file);
        ISQLEditorConnectionInfo connectionInfo = encodedConnection != null && !encodedConnection.trim().equals("") ? SQLEditorConnectionInfo.decode((String)encodedConnection) : SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
        return connectionInfo;
    }

    public static String getEncodedConnectionInfo(IFile file) {
        String encodedConnection = null;
        if (file != null) {
            try {
                encodedConnection = file.getPersistentProperty(new QualifiedName("org.eclipse.datatools.sqltools.sqlscrapbook", "encodedConnection"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return encodedConnection;
    }

    public static void setEncodedConnectionInfo(IFile fileResource, String encodedConnection) {
        try {
            if (fileResource.exists()) {
                fileResource.setPersistentProperty(new QualifiedName("org.eclipse.datatools.sqltools.sqlscrapbook", "encodedConnection"), encodedConnection);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static ISQLEditorConnectionInfo getConnectionInfoFromPreference() {
        ISQLEditorConnectionInfo editorConnectionInfo = SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
        String dftConn = SqlscrapbookPlugin.getDefault().getPreferenceStore().getString("SQLEditor.connection.info");
        if (dftConn != null && !dftConn.equals("")) {
            editorConnectionInfo = SQLEditorConnectionInfo.decode((String)dftConn);
        }
        return editorConnectionInfo;
    }
}

