/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import org.eclipse.datatools.sqltools.common.ui.util.HTMLTextPresenter;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.contentassist.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SQLInformationProvider;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.SQLAutoIndentStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.SQLCommentAutoIndentStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.indent.SQLStringAutoIndentStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.BestMatchHover;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLAnnotationHover;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCodeScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProcessor;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDoubleClickStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLWordStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private SQLEditor fEditor;
    private SQLCompletionProcessor fCompletionProcessor;
    private ISQLDBProposalsService fDBProposalsService;

    public SQLSourceViewerConfiguration(SQLEditor editor) {
        this.fEditor = editor;
        this.fCompletionProcessor = new SQLCompletionProcessor();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new SQLAnnotationHover((IEditorPart)this.getSQLEditor());
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("sql_code".equals(contentType) || "__dftl_partition_content_type".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLAutoIndentStrategy("___sql_partitioning")};
        }
        if ("sql_comment".equals(contentType) || "sql_multiline_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLCommentAutoIndentStrategy("___sql_partitioning")};
        }
        if ("sql_character".equals(contentType) || "sql_double_quotes_identifier".equals(contentType)) {
            return new IAutoEditStrategy[]{new SQLStringAutoIndentStrategy("sql_character")};
        }
        return null;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___sql_partitioning";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        if (this.fCompletionProcessor == null) {
            this.fCompletionProcessor = new SQLCompletionProcessor();
        }
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fCompletionProcessor, "__dftl_partition_content_type");
        ISQLDBProposalsService proposalsService = this.getDBProposalsService();
        if (proposalsService != null) {
            this.fCompletionProcessor.setDBProposalsService(proposalsService);
        }
        assistant.enableAutoActivation(store.getBoolean("enable.auto.activation"));
        assistant.setAutoActivationDelay(store.getInt("auto.activation.delay"));
        assistant.setProposalPopupOrientation(10);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        Color foreground = new Color((Device)SQLEditorPlugin.getDisplay(), 0, 0, 0);
        Color background = new Color((Device)SQLEditorPlugin.getDisplay(), 255, 255, 255);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextInformationPopupBackground(background);
        assistant.enableAutoInsert(store.getBoolean("insert.single.proposals.auto"));
        return assistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setDocumentPartitioning("___sql_partitioning");
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this.getSQLEditor().getConnectionInfo().getDatabaseVendorDefinitionId());
        SQLWordStrategy formattingStrategy = new SQLWordStrategy(factory.getSQLService().getSQLSyntax());
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__dftl_partition_content_type");
        return formatter;
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SQLDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        SQLColorProvider colorProvider = this.getSQLEditor().getSQLColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        String docPartitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        reconciler.setDocumentPartitioning(docPartitioning);
        SQLCodeScanner sqlCodeScanner = new SQLCodeScanner(SQLEditorPlugin.getDefault().getSQLColorProvider());
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this.getSQLEditor().getConnectionInfo().getDatabaseVendorDefinitionId());
        if (factory != null) {
            sqlCodeScanner.setSQLSyntax(factory.getSQLService().getSQLSyntax());
        }
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)sqlCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_MULTILINE_COMMENT_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "sql_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_COMMENT_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "sql_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_QUOTED_LITERAL_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "sql_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_DELIMITED_IDENTIFIER_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "sql_double_quotes_identifier");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_double_quotes_identifier");
        return reconciler;
    }

    public SQLEditor getSQLEditor() {
        return this.fEditor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new BestMatchHover((IEditorPart)this.getSQLEditor());
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        if (this.fCompletionProcessor != null) {
            this.fCompletionProcessor.setDBProposalsService(dbProposalsService);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SQLPartitionScanner.SQL_PARTITION_TYPES;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"--", ""};
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        SQLInformationProvider provider = new SQLInformationProvider((IEditorPart)this.getSQLEditor());
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        for (int i = 0; i < contentTypes.length; ++i) {
            presenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
        }
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

