/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class DeployAction
extends SelectionDispatchAction {
    public DeployAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.DeployAction_label);
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.save_to_database_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(IStructuredSelection selection) {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null && activeEditor.getAdapter(SQLEditor.class) != null) {
            SQLEditor editor = (SQLEditor)((Object)activeEditor.getAdapter(SQLEditor.class));
            return selection.size() == 1 && selection.getFirstElement() instanceof IASTDeployable && editor.isConnected();
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof IASTDeployable)) {
            return;
        }
        IASTDeployable node = (IASTDeployable)selection.getFirstElement();
        IEditorInput input = node.getEditorInput();
        SQLEditor editor = (SQLEditor)this.getSite().getPage().getActiveEditor();
        if (editor.getSQLType() != 100) {
            try {
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (RuntimeException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
        } else if (editor.isConnected()) {
            try {
                DatabaseIdentifier databaseIdentifier = editor.getDatabaseIdentifier();
                IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
                controlCon.executeDDL(new String[]{node.getSQLText()});
                String dbObjectName = node.getDBObjectName();
                int parseType = node.getType();
                int type = this.getObjectType(parseType);
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.DeployAction_save_information, (String)NLS.bind((String)Messages.DeployAction_save_message, (Object)dbObjectName));
            }
            catch (SQLException e) {
                Status fstatus = new Status(4, "org.eclipse.datatools.sqltools.sqleditor", 0, e.getMessage(), (Throwable)e);
                final String title = Messages.DeployAction_error_title;
                final String msg = Messages.DeployAction_error_message;
                Display display = this.getShell().getDisplay();
                display.asyncExec(new Runnable((IStatus)fstatus){
                    private final /* synthetic */ IStatus val$fstatus;
                    {
                        this.val$fstatus = val$fstatus;
                    }

                    public void run() {
                        ErrorDialog.openError((Shell)DeployAction.this.getShell(), (String)title, (String)msg, (IStatus)this.val$fstatus);
                    }
                });
                SQLEditorPlugin.getDefault().log(e);
            }
            catch (NoSuchProfileException e) {
                SQLEditorPlugin.getDefault().log(e);
            }
        }
    }

    private int getObjectType(int parseType) {
        int type = 0;
        switch (parseType) {
            case 58: {
                type = 0;
                break;
            }
            case 59: {
                type = 1;
                break;
            }
            case 61: {
                type = 3;
                break;
            }
            case 60: {
                type = 2;
            }
        }
        return type;
    }
}

