/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.result;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionInitializer;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.result.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;

public abstract class ResultSupportRunnable
extends Job
implements Runnable {
    static String _LINESEPARATOR = System.getProperty("line.separator");
    protected OperationCommand _parentOperCommand;
    private static int TASK_TOTAL = 100;
    private static int TASK_CONNECTION = 10;
    private static int TASK_STATEMENT = 10;
    private static int TASK_RUN = 50;
    private static int TASK_ITERATE = 30;
    protected Statement _stmt;
    protected boolean _terminated = false;
    protected IProgressMonitor _monitor = null;
    protected IProgressMonitor _parentMonitor = null;
    protected DatabaseIdentifier _databaseIdentifier = null;
    protected Runnable _connKiller = null;
    protected ResultsViewAPI resultsViewAPI = ResultsViewAPI.getInstance();
    protected int _lastUpdateCount = -1;
    protected OperationCommand _operationCommand = null;
    protected int _actionType = -1;
    protected String _consumerName = null;
    protected boolean _needsInitConnection = true;

    public ResultSupportRunnable(String name, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier) {
        super(name == null ? Messages.ResultSupportRunnable_name : name);
        this._databaseIdentifier = databaseIdentifier;
        this._parentMonitor = parentMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        block31: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this._monitor = monitor;
            monitor.beginTask(Messages.ResultSupportRunnable_name, TASK_TOTAL);
            monitor.subTask(Messages.ResultSupportRunnable_task_connection);
            if (this._parentOperCommand == null) {
                this.resultsViewAPI.createNewInstance(this.getOperationCommand(), this.getTerminateHandler());
            } else {
                this.resultsViewAPI.createSubInstance(this._parentOperCommand, this.getOperationCommand(), this.getTerminateHandler());
            }
            Connection connection = this.getConnection();
            this.initConnection(connection);
            try {
                boolean moreResult;
                block30: {
                    block29: {
                        monitor.worked(TASK_CONNECTION);
                        if (monitor.isCanceled()) {
                            this.terminateExecution();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        monitor.subTask(Messages.ResultSupportRunnable_task_statement);
                        try {
                            this._stmt = this.prepareStatement(connection);
                            try {
                                this._stmt.setMaxFieldSize(16384);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            monitor.worked(TASK_STATEMENT);
                            if (!monitor.isCanceled()) break block29;
                            this.terminateExecution();
                            IStatus e = Status.CANCEL_STATUS;
                            return e;
                        }
                        catch (Throwable th) {
                            OperationCommand operationCommand = this.getOperationCommand();
                            synchronized (operationCommand) {
                                this.resultsViewAPI.appendThrowable(this.getOperationCommand(), th);
                                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), th.getMessage());
                                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 6);
                            }
                            operationCommand = Status.CANCEL_STATUS;
                            this.handleEnd(connection, this._stmt);
                            monitor.done();
                            return operationCommand;
                        }
                    }
                    monitor.subTask(Messages.ResultSupportRunnable_task_run);
                    moreResult = false;
                    try {
                        moreResult = this.runStatement(this._stmt);
                        monitor.worked(TASK_RUN);
                        if (!monitor.isCanceled()) break block30;
                        this.terminateExecution();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (Throwable th) {
                        OperationCommand operationCommand;
                        this.resultsViewAPI.appendThrowable(this.getOperationCommand(), th);
                        if (th instanceof SQLException) {
                            this.handleSQLException((SQLException)th);
                        } else {
                            operationCommand = this.getOperationCommand();
                            synchronized (operationCommand) {
                                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), th.getMessage());
                                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 6);
                            }
                        }
                        operationCommand = Status.CANCEL_STATUS;
                        this.handleEnd(connection, this._stmt);
                        monitor.done();
                        return operationCommand;
                    }
                }
                monitor.subTask(Messages.ResultSupportRunnable_task_iterate);
                boolean success = this.handleSuccess(moreResult);
                if (success) {
                    monitor.worked(TASK_ITERATE);
                    break block31;
                }
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            finally {
                this.handleEnd(connection, this._stmt);
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    protected void initConnection(Connection connection) {
        IConnectionInitializer init;
        this._connKiller = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)this._databaseIdentifier).getConnectionService().getConnectionKiller(this._databaseIdentifier, connection);
        if (this._needsInitConnection && (init = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)this._databaseIdentifier).getConnectionService().getConnectionInitializer()) != null) {
            init.init(this._databaseIdentifier, connection, this.getConfiguration());
        }
    }

    public void run() {
        this.run(null);
    }

    protected abstract Connection getConnection();

    protected abstract OperationCommand createDefaultOperationCommand();

    public OperationCommand getOperationCommand() {
        if (this._operationCommand == null) {
            this._operationCommand = this.createDefaultOperationCommand();
        }
        return this._operationCommand;
    }

    public OperationCommand getParentOperationCommand() {
        return this._parentOperCommand;
    }

    protected abstract Statement prepareStatement(Connection var1) throws SQLException;

    protected abstract boolean runStatement(Statement var1) throws SQLException;

    protected void handleEnd(Connection connection, Statement stmt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSuccess(boolean moreResult) {
        if (this.isTerminated() || this.isCanceled()) {
            return false;
        }
        try {
            this.loopThroughResults(this._stmt, moreResult);
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 3);
            }
        }
        catch (SQLException ex) {
            this.resultsViewAPI.appendThrowable(this.getOperationCommand(), (Throwable)ex);
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                this.resultsViewAPI.updateStatus(this.getOperationCommand(), 6);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSQLException(SQLException exception) {
        this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), exception.getMessage());
        if (this.isTerminated() || this.isCanceled()) {
            return;
        }
        try {
            this.loopThroughResults(this._stmt, this._stmt.getMoreResults());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        OperationCommand operationCommand = this.getOperationCommand();
        synchronized (operationCommand) {
            this.resultsViewAPI.updateStatus(this.getOperationCommand(), 6);
        }
    }

    protected Runnable getTerminateHandler() {
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (ResultSupportRunnable.this.isTerminated()) {
                    return;
                }
                OperationCommand operationCommand = ResultSupportRunnable.this.getOperationCommand();
                synchronized (operationCommand) {
                    if (ResultSupportRunnable.this._stmt != null) {
                        try {
                            ResultSupportRunnable.this._stmt.cancel();
                        }
                        catch (Exception e) {
                            SQLEditorPlugin.getDefault().log(e);
                        }
                    }
                    ResultSupportRunnable.this._terminated = true;
                    OperationCommand operationCommand2 = ResultSupportRunnable.this.getOperationCommand();
                    synchronized (operationCommand2) {
                        ResultSupportRunnable.this.resultsViewAPI.updateStatus(ResultSupportRunnable.this.getOperationCommand(), 5);
                    }
                }
                if (ResultSupportRunnable.this._monitor != null && !ResultSupportRunnable.this._monitor.isCanceled()) {
                    ResultSupportRunnable.this.cancel();
                }
                if (ResultSupportRunnable.this._connKiller != null) {
                    ResultSupportRunnable.this._connKiller.run();
                }
            }
        };
        return run;
    }

    protected boolean needLoopThroughResults() {
        return true;
    }

    public void loopThroughResults(Statement cstmt, boolean moreResult) throws SQLException {
        boolean hasException = false;
        boolean lastException = false;
        SQLException exception = null;
        ResultSet rs = null;
        ArrayList<Integer> updateCountList = new ArrayList<Integer>();
        while (!this.isTerminated() && this.needLoopThroughResults()) {
            if (this.isCanceled()) {
                this.terminateExecution();
                throw new SQLException(Messages.ResultSupportRunnable_exception_terminated);
            }
            int updateCount = 0;
            if (!lastException) {
                try {
                    if (moreResult && (rs = cstmt.getResultSet()) != null) {
                        if (this._lastUpdateCount != -1) {
                            this.resultsViewAPI.appendUpdateCountMessage(this.getOperationCommand(), this._lastUpdateCount);
                            this._lastUpdateCount = -1;
                        }
                        this.resultsViewAPI.appendResultSet(this.getOperationCommand(), rs);
                    }
                    if ((updateCount = cstmt.getUpdateCount()) >= 0) {
                        updateCountList.add(new Integer(updateCount));
                        if (this._lastUpdateCount != -1) {
                            this.resultsViewAPI.appendUpdateCountMessage(this.getOperationCommand(), this._lastUpdateCount);
                        }
                        this._lastUpdateCount = updateCount;
                    }
                    if (updateCount < 0 && rs == null) break;
                    moreResult = cstmt.getMoreResults();
                    rs = null;
                    continue;
                }
                catch (SQLException ex) {
                    this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                    exception = ex;
                    hasException = true;
                    lastException = true;
                    if (cstmt == null || this.getConnection() == null || this.getConnection().isClosed()) break;
                }
            }
            try {
                moreResult = cstmt.getMoreResults();
                lastException = false;
            }
            catch (SQLException ex) {
                if (ex.getSQLState() != null && exception != null && ex.getSQLState().equals(exception.getSQLState())) break;
                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), ex.getMessage());
                exception = ex;
                hasException = true;
                lastException = true;
                if (cstmt != null && this.getConnection() != null && !this.getConnection().isClosed()) continue;
                break;
            }
        }
        int count = updateCountList.size();
        if (!(cstmt instanceof CallableStatement)) {
            if (this._lastUpdateCount != -1) {
                this.resultsViewAPI.appendUpdateCountMessage(this.getOperationCommand(), this._lastUpdateCount);
                this._lastUpdateCount = -1;
            }
        } else if ((count < 2 || ((Integer)updateCountList.get(count - 1)).intValue() != ((Integer)updateCountList.get(count - 2)).intValue()) && this._lastUpdateCount != -1) {
            this.resultsViewAPI.appendUpdateCountMessage(this.getOperationCommand(), this._lastUpdateCount);
            this._lastUpdateCount = -1;
        }
        if (hasException) {
            throw exception;
        }
    }

    protected boolean isTerminated() {
        return this._terminated;
    }

    protected boolean isCanceled() {
        return this._monitor != null && this._monitor.isCanceled() || this._parentMonitor != null && this._parentMonitor.isCanceled();
    }

    protected void terminateExecution() {
        this.getTerminateHandler().run();
    }

    public abstract ILaunchConfiguration getConfiguration();

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public int getOperationStatus() {
        return this.resultsViewAPI.getCurrentStatus(this.getOperationCommand());
    }

    public void setParentOperCommand(OperationCommand operCommand) {
        this._parentOperCommand = operCommand;
    }

    public int getActionType() {
        if (this._actionType == -1) {
            this._actionType = 1;
        }
        return this._actionType;
    }

    public void setActionType(int type) {
        this._actionType = type;
    }

    public String getConsumerName() {
        if (this._consumerName == null) {
            this._consumerName = Messages.sqlEditorName;
        }
        return this._consumerName;
    }

    public void setConsumerName(String name) {
        this._consumerName = name;
    }
}

