/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.editor.template.SQLTemplate;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.SQLIntelligentTemplate;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.SQLTemplateReaderWriter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.osgi.framework.Bundle;

public class SQLContributionTemplateStore
extends TemplateStore {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String AUTO_INSERT = "autoinsert";
    private static final String TEMPLATE = "template";
    private static final String PATTERN = "pattern";
    private static final String INCLUDE = "include";
    private static final String FILE = "file";
    private static final String TRANSLATIONS = "translations";
    private static final String PROPOSAL_POPUP_DESCRIPTION = "proposalPopupDescription";
    private HashMap _intelligentTemplateList = new HashMap();

    public SQLContributionTemplateStore(IPreferenceStore store, String key) {
        super(store, key);
    }

    public SQLContributionTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    protected void loadContributedTemplates() throws IOException {
        IConfigurationElement[] extensions = SQLContributionTemplateStore.getTemplateExtensions();
        Collection contributed = this.readContributedTemplates(extensions);
        Iterator it = contributed.iterator();
        while (it.hasNext()) {
            TemplatePersistenceData data = (TemplatePersistenceData)it.next();
            this.internalAdd(data);
        }
    }

    private Collection readContributedTemplates(IConfigurationElement[] extensions) throws IOException {
        ArrayList templates = new ArrayList();
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].getName().equals(TEMPLATE)) {
                this.createTemplate(templates, extensions[i]);
                continue;
            }
            if (!extensions[i].getName().equals(INCLUDE)) continue;
            this.readIncludedTemplates(templates, extensions[i]);
        }
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private void readIncludedTemplates(Collection templates, IConfigurationElement element) throws IOException {
        Bundle plugin;
        URL url;
        String file = element.getAttribute(FILE);
        if (file != null && (url = FileLocator.find((Bundle)(plugin = Platform.getBundle((String)element.getContributor().getName())), (IPath)Path.fromOSString((String)file), null)) != null) {
            Object v1;
            PropertyResourceBundle bundle = null;
            InputStream bundleStream = null;
            BufferedInputStream stream = null;
            try {
                URL bundleURL;
                String translations = element.getAttribute(TRANSLATIONS);
                if (translations != null && (bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), null)) != null) {
                    bundleStream = bundleURL.openStream();
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                stream = new BufferedInputStream(url.openStream());
                SQLTemplateReaderWriter reader = new SQLTemplateReaderWriter();
                TemplatePersistenceData[] datas = reader.read(stream, bundle);
                for (int i = 0; i < datas.length; ++i) {
                    TemplatePersistenceData data = datas[i];
                    if (data.isCustom()) {
                        if (data.getId() == null) {
                            SQLEditorPlugin.getDefault().log(Messages.format(Messages.ContributionTemplateStore_ignore_no_id, data.getTemplate().getName()));
                            continue;
                        }
                        SQLEditorPlugin.getDefault().log(Messages.format(Messages.ContributionTemplateStore_ignore_deleted, data.getTemplate().getName()));
                        continue;
                    }
                    if (!this.validateTemplate(data.getTemplate())) {
                        if (!this.contextExists(data.getTemplate().getContextTypeId())) continue;
                        SQLEditorPlugin.getDefault().log(Messages.format(Messages.ContributionTemplateStore_ignore_validation_failed, data.getTemplate().getName()));
                        continue;
                    }
                    templates.add(data);
                }
                Object var15_14 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var15_15 = null;
                try {
                    try {
                        if (bundleStream != null) {
                            bundleStream.close();
                        }
                        v0 = null;
                    }
                    catch (IOException x) {
                        v0 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var18_21 = v0;
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException x2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                try {
                    if (bundleStream != null) {
                        bundleStream.close();
                    }
                    v1 = null;
                }
                catch (IOException x) {
                    v1 = null;
                }
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var18_20 = v1;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException x2) {}
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException e) {
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private void createTemplate(Collection map, IConfigurationElement element) {
        String pattern;
        String name;
        String id;
        String contextTypeId = element.getAttribute(CONTEXT_TYPE_ID);
        if (this.contextExists(contextTypeId) && SQLContributionTemplateStore.isValidTemplateId(id = element.getAttribute(ID)) && (name = element.getAttribute(NAME)) != null && (pattern = element.getChildren(PATTERN)[0].getValue()) != null) {
            String autoInsert;
            String desc = element.getAttribute(DESCRIPTION);
            if (desc == null) {
                desc = "";
            }
            boolean bAutoInsert = (autoInsert = element.getAttribute(AUTO_INSERT)) == null ? true : Boolean.valueOf(autoInsert);
            String proprosal = element.getAttribute(PROPOSAL_POPUP_DESCRIPTION);
            if (proprosal != null) {
                System.out.println("asdf");
            }
            Template template = new Template(name, desc, contextTypeId, pattern, bAutoInsert);
            TemplatePersistenceData data = new TemplatePersistenceData(template, true, id);
            if (this.validateTemplate(template)) {
                map.add(data);
            }
        }
    }

    private static boolean isValidTemplateId(String id) {
        return id != null && id.trim().length() != 0;
    }

    protected void handleException(IOException x) {
        SQLEditorPlugin.getDefault().log(x);
    }

    public void registerIntelligentTemplate(SQLTemplate template) {
        this._intelligentTemplateList.put(template.getClass().getName(), template);
    }

    public SQLIntelligentTemplate getRegisteredIntelligentTemplate(String templateID) {
        SQLIntelligentTemplate sqlTemplate = null;
        for (int i = 0; i < this._intelligentTemplateList.size(); ++i) {
            SQLIntelligentTemplate template = (SQLIntelligentTemplate)((Object)this._intelligentTemplateList.get(templateID));
            if (template == null) continue;
            sqlTemplate = template;
            break;
        }
        return sqlTemplate;
    }
}

