/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLWordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.widgets.Display;

public class SQLCodeScanner
extends RuleBasedScanner {
    private IToken commentToken;
    private IToken stringToken;
    private IToken keywordToken;
    private IToken datatypeToken;
    private IToken functionToken;
    private IToken delimitedIdentifierToken;
    private IToken otherToken;
    private List rules;

    public SQLCodeScanner(SQLColorProvider colorProvider) {
        if (Display.getDefault().getHighContrast()) {
            this.commentToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_COMMENT_COLOR)));
            this.stringToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_QUOTED_LITERAL_COLOR)));
            this.keywordToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_KEYWORD_COLOR), null, 1));
            this.datatypeToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_TYPE_COLOR), null, 1));
            this.functionToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_IDENTIFIER_COLOR)));
            this.delimitedIdentifierToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_DELIMITED_IDENTIFIER_COLOR)));
            this.otherToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_HC_DEFAULT_COLOR)));
        } else {
            this.commentToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_COMMENT_COLOR)));
            this.stringToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_QUOTED_LITERAL_COLOR)));
            this.keywordToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_KEYWORD_COLOR), null, 1));
            this.datatypeToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_TYPE_COLOR), null, 1));
            this.functionToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_IDENTIFIER_COLOR)));
            this.delimitedIdentifierToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_DELIMITED_IDENTIFIER_COLOR)));
            this.otherToken = new Token((Object)new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_DEFAULT_COLOR)));
        }
        this.setDefaultReturnToken(this.otherToken);
        this.rules = new ArrayList();
        this.rules.add(new EndOfLineRule("--", this.commentToken));
        this.rules.add(new SingleLineRule("'", "'", this.stringToken, '\\'));
        this.rules.add(new SingleLineRule("\"", "\"", this.delimitedIdentifierToken, '\\'));
        this.rules.add(new WhitespaceRule((IWhitespaceDetector)new SQLWhiteSpaceDetector()));
        IRule[] result = new IRule[this.rules.size()];
        this.rules.toArray(result);
        this.setRules(result);
    }

    public void setSQLSyntax(ISQLSyntax sqlSyntax) {
        if (sqlSyntax == null) {
            return;
        }
        ArrayList<WordRule> sqlRules = new ArrayList<WordRule>();
        WordRule wordRule = new WordRule((IWordDetector)new SQLWordDetector(), this.otherToken);
        String[] reservedWords = sqlSyntax.getReservedwords();
        for (int i = 0; i < reservedWords.length; ++i) {
            wordRule.addWord(reservedWords[i].toLowerCase(), this.keywordToken);
            wordRule.addWord(reservedWords[i].toUpperCase(), this.keywordToken);
        }
        String[] unreservedWords = sqlSyntax.getUnreservedwords();
        for (int i = 0; i < unreservedWords.length; ++i) {
            wordRule.addWord(unreservedWords[i].toLowerCase(), this.keywordToken);
            wordRule.addWord(unreservedWords[i].toUpperCase(), this.keywordToken);
        }
        String[] datatypes = sqlSyntax.getTypes();
        for (int i = 0; i < datatypes.length; ++i) {
            wordRule.addWord(datatypes[i].toLowerCase(), this.datatypeToken);
            wordRule.addWord(datatypes[i].toUpperCase(), this.datatypeToken);
        }
        String[] functions = sqlSyntax.getFunctions();
        for (int i = 0; i < functions.length; ++i) {
            wordRule.addWord(functions[i].toLowerCase(), this.functionToken);
            wordRule.addWord(functions[i].toUpperCase(), this.functionToken);
        }
        String[] constants = sqlSyntax.getConstants();
        for (int i = 0; i < constants.length; ++i) {
            wordRule.addWord(constants[i].toLowerCase(), this.datatypeToken);
            wordRule.addWord(constants[i].toUpperCase(), this.datatypeToken);
        }
        sqlRules.addAll(this.rules);
        sqlRules.add(wordRule);
        IRule[] result = new IRule[sqlRules.size()];
        sqlRules.toArray(result);
        this.setRules(result);
    }

    public class SQLWhiteSpaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }
}

