/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sql.reference.ITable;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposalsRequest;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SQLDBProposalsService
implements ISQLDBProposalsService {
    private ISQLEditorConnectionInfo fConnInfo;
    private List fDBProposalList;
    private SQLDBProposalsRequest fRequest;

    public SQLDBProposalsService(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo;
        this.fDBProposalList = new ArrayList();
        this.fRequest = null;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public List getDBProposals() {
        return this.fDBProposalList;
    }

    protected Schema getSchema(Database database, String catalogName, String schemaName) {
        EList schemaList = ModelUtil.getSchemas((Database)database, (String)catalogName);
        Schema schema = null;
        for (int i = 0; i < schemaList.size(); ++i) {
            Schema thisSchema = (Schema)schemaList.get(i);
            if (!thisSchema.getName().equalsIgnoreCase(schemaName)) continue;
            schema = thisSchema;
            break;
        }
        return schema;
    }

    protected void loadSchemas(Database database, String catalogName, boolean clear) {
        if (clear) {
            this.fDBProposalList.clear();
        }
        EList schemaList = ModelUtil.getSchemas((Database)database, (String)catalogName);
        for (int i = 0; i < schemaList.size(); ++i) {
            Schema thisSchema = (Schema)schemaList.get(i);
            this.fDBProposalList.add(new SQLDBProposal((EObject)thisSchema));
        }
    }

    public SQLDBProposalsRequest getSQLDBProposalRequest() {
        return this.fRequest;
    }

    protected void loadColumns(Table table) {
        this.loadColumns(table, true, table.getName());
    }

    protected void loadColumns(Table table, boolean clear, String alias) {
        if (table != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList columns = table.getColumns();
            for (int j = 0; j < columns.size(); ++j) {
                Column column = (Column)columns.get(j);
                this.fDBProposalList.add(new SQLDBProposal((EObject)column, alias));
            }
        }
    }

    protected void loadDBProposals(SQLDBProposalsRequest request) {
        block14: {
            this.fDBProposalList.clear();
            Database database = this.fConnInfo.getDatabase();
            String fImpliedSchemaName = this.fConnInfo.getDefaultSchemaName();
            if (database == null) break block14;
            int proposalsType = request.getScope();
            if ((proposalsType & 4) == 4) {
                this.loadSchemas(database, request.getDatabase(), false);
                return;
            }
            if ((proposalsType & 0x800) == 2048) {
                this.loadEvents(database, false);
                return;
            }
            Schema schema = this.getSchema(database, request.getDatabase(), request.getSchema());
            if ((proposalsType & 8) == 8) {
                this.loadTables(schema, false);
                this.createAliasTableProposals(request, false);
            }
            if ((proposalsType & 0x200) == 512) {
                this.loadFunctions(schema, false);
            }
            if ((proposalsType & 0x100) == 256) {
                this.loadProcedures(schema, false);
            }
            if ((proposalsType & 0x400) == 1024) {
                this.loadTriggers(schema, false);
            }
            if ((proposalsType & 0x20) == 32) {
                String realTableName = request.getRealTable();
                if (realTableName != null && realTableName.trim().length() > 0) {
                    Table table = null;
                    EList tables = schema.getTables();
                    for (int i = 0; i < tables.size(); ++i) {
                        table = (Table)tables.get(i);
                        if (!table.getName().equals(realTableName)) continue;
                        this.loadColumns(table, false, request.getTable());
                        break;
                    }
                } else {
                    List ctxTables = request.getContextTables();
                    if (!ctxTables.isEmpty()) {
                        Iterator iter = ctxTables.iterator();
                        block1: while (iter.hasNext()) {
                            ITable ref = (ITable)iter.next();
                            Schema ctxSchema = schema;
                            if (ref.getOwner() != null) {
                                ctxSchema = this.getSchema(database, request.getDatabase(), ref.getOwner());
                            }
                            if (ctxSchema == null) continue;
                            EList tables = ctxSchema.getTables();
                            for (int i = 0; i < tables.size(); ++i) {
                                Table table = (Table)tables.get(i);
                                if (!table.getName().equals(ref.getName())) continue;
                                this.loadColumns(table, false, ref.getAliasName());
                                continue block1;
                            }
                        }
                    }
                }
            }
        }
    }

    protected void loadTables(Schema schema) {
        this.loadTables(schema, true);
    }

    protected void loadTables(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList tables = schema.getTables();
            for (int i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)table));
            }
        }
    }

    protected void createAliasTableProposals(SQLDBProposalsRequest request, boolean clear) {
        if (clear) {
            this.fDBProposalList.clear();
        }
        List tables = request.getContextTables();
        for (int i = 0; i < tables.size(); ++i) {
            ITable table = (ITable)tables.get(i);
            this.fDBProposalList.add(new SQLDBProposal(table.getAliasName()));
        }
    }

    protected void loadProcedures(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList procedures = schema.getProcedures();
            for (int i = 0; i < procedures.size(); ++i) {
                Procedure proc = (Procedure)procedures.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)proc));
            }
        }
    }

    protected void loadFunctions(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList funcs = schema.getUDFs();
            for (int i = 0; i < funcs.size(); ++i) {
                Function func = (Function)funcs.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)func));
            }
        }
    }

    protected void loadTriggers(Schema schema, boolean clear) {
        if (schema != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList funcs = schema.getUDFs();
            for (int i = 0; i < funcs.size(); ++i) {
                Function func = (Function)funcs.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)func));
            }
        }
    }

    protected void loadEvents(Database database, boolean clear) {
        if (database != null) {
            if (clear) {
                this.fDBProposalList.clear();
            }
            EList events = database.getEvents();
            for (int i = 0; i < events.size(); ++i) {
                Event event = (Event)events.get(i);
                this.fDBProposalList.add(new SQLDBProposal((EObject)event));
            }
        }
    }

    public boolean populate(final SQLDBProposalsRequest request) {
        boolean loaded = false;
        if (request != null) {
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            boolean connected = false;
            if (connInfo != null && connInfo.getConnectionProfile() != null) {
                connected = connInfo.getConnectionProfile().isConnected();
            }
            if (connected) {
                loaded = true;
                try {
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    progressService.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            SQLDBProposalsService.this.loadDBProposals(request);
                        }
                    });
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
        return loaded;
    }

    public ISQLEditorConnectionInfo getSQLEditorConnectionInfo() {
        return this.fConnInfo;
    }
}

