/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorFileEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.FileEditorInputFactory;

public class SQLEditorInputFactory
implements IElementFactory {
    public static final String ID_FACTORY = "org.eclipse.datatools.sqltools.sqleditor.SQLEditorInputFactory";
    public static final String ID_FILE_EDITOR_INPUT = "SQLEditorFileEditorInput";
    public static final String ID_STORAGE_EDITOR_INPUT = "SQLEditorStorageEditorInput";
    public static final String KEY_CONN_INFO_CODE = "connInfoName";
    public static final String KEY_DEFAULT_SCHEMA_NAME = "defaultSchemaName";
    public static final String KEY_EDITOR_INPUT_TYPE = "editorInputType";
    public static final String KEY_STORAGE_CONTENT = "storageContent";
    public static final String KEY_STORAGE_NAME = "storageName";

    public IAdaptable createElement(IMemento memento) {
        ISQLEditorInput input = null;
        String editorInputType = memento.getString(KEY_EDITOR_INPUT_TYPE);
        if (editorInputType.equals(ID_FILE_EDITOR_INPUT)) {
            FileEditorInput fileInput;
            IFile fileResource;
            FileEditorInputFactory fileInputFactory = new FileEditorInputFactory();
            IAdaptable adaptable = fileInputFactory.createElement(memento);
            if (adaptable instanceof FileEditorInput && (fileResource = (fileInput = (FileEditorInput)adaptable).getFile()) != null) {
                SQLEditorFileEditorInput sqlFileInput = new SQLEditorFileEditorInput(fileResource);
                ISQLEditorConnectionInfo connInfo = null;
                String connInfoCode = memento.getString(KEY_CONN_INFO_CODE);
                if (connInfoCode != null) {
                    connInfo = SQLEditorConnectionInfo.decode(connInfoCode);
                    sqlFileInput.setConnectionInfo(connInfo);
                }
                input = sqlFileInput;
            }
        } else if (editorInputType.equals(ID_STORAGE_EDITOR_INPUT)) {
            String contentName = memento.getString(KEY_STORAGE_NAME);
            String contentString = memento.getString(KEY_STORAGE_CONTENT);
            SQLEditorStorage storage = new SQLEditorStorage(contentName, contentString);
            SQLEditorStorageEditorInput sqlStorageInput = new SQLEditorStorageEditorInput(storage);
            ISQLEditorConnectionInfo connInfo = null;
            String connInfoCode = memento.getString(KEY_CONN_INFO_CODE);
            if (connInfoCode != null) {
                connInfo = SQLEditorConnectionInfo.decode(connInfoCode);
                sqlStorageInput.setConnectionInfo(connInfo);
            }
            input = sqlStorageInput;
        }
        return input;
    }

    public static void saveState(IMemento memento, SQLEditorFileEditorInput input) {
        memento.putString(KEY_EDITOR_INPUT_TYPE, ID_FILE_EDITOR_INPUT);
        FileEditorInputFactory.saveState((IMemento)memento, (FileEditorInput)input);
        ISQLEditorConnectionInfo connInfo = input.getConnectionInfo();
        if (connInfo != null) {
            String connInfoCode = connInfo.encode();
            memento.putString(KEY_CONN_INFO_CODE, connInfoCode);
        }
    }

    public static void saveState(IMemento memento, SQLEditorStorageEditorInput input) {
        memento.putString(KEY_EDITOR_INPUT_TYPE, ID_STORAGE_EDITOR_INPUT);
        String storageName = null;
        String storageContent = "";
        IStorage storage = input.getStorage();
        if (storage != null) {
            storageName = storage.getName();
            if (storage instanceof SQLEditorStorage) {
                SQLEditorStorage sqlEditorStorage = (SQLEditorStorage)storage;
                storageContent = sqlEditorStorage.getContentsString();
            }
        }
        memento.putString(KEY_STORAGE_NAME, storageName);
        memento.putString(KEY_STORAGE_CONTENT, storageContent);
        ISQLEditorConnectionInfo connInfo = input.getConnectionInfo();
        if (connInfo != null) {
            String connInfoCode = connInfo.encode();
            memento.putString(KEY_CONN_INFO_CODE, connInfoCode);
        }
    }
}

