/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

public class SQLDBProposal {
    public static final int SCHEMA_OBJTYPE = 1;
    public static final int TABLE_OBJTYPE = 2;
    public static final int TABLECOLUMN_OBJTYPE = 3;
    public static final int UNKNOWN_OBJTYPE = -1;
    private EObject fDBObject;
    private Image fImage = null;
    private String fName = null;
    private String fParentName = null;
    private EObject fParentObject;
    private int fType = -1;

    public SQLDBProposal(EObject dbObject) {
        this.fDBObject = dbObject;
        if (dbObject instanceof Schema) {
            this.fType = 1;
            this.fName = ((Schema)dbObject).getName();
            this.fParentName = ((Schema)dbObject).getDatabase().getName();
            this.fParentObject = ((Schema)dbObject).getDatabase();
            this.setImage(SQLEditorResources.getImage("schema"));
        } else if (dbObject instanceof Table) {
            this.fType = 2;
            this.fName = ((Table)dbObject).getName();
            this.fParentName = ((Table)dbObject).getSchema().getName();
            this.fParentObject = ((Table)dbObject).getSchema();
            this.setImage(SQLEditorResources.getImage("table"));
        } else if (dbObject instanceof Column) {
            this.fType = 3;
            this.fName = ((Column)dbObject).getName();
            this.fParentName = ((Column)dbObject).getTable().getSchema().getName() + "." + ((Column)dbObject).getTable().getName();
            this.fParentObject = ((Column)dbObject).getTable();
            this.setImage(SQLEditorResources.getImage("column"));
        }
    }

    public EObject getDBObject() {
        return this.fDBObject;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getName() {
        return this.fName;
    }

    public String getParentName() {
        return this.fParentName;
    }

    public EObject getParentObject() {
        return this.fParentObject;
    }

    public int getType() {
        return this.fType;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setParentName(String parentName) {
        this.fParentName = parentName;
    }

    public String toString() {
        return this.fName;
    }
}

