/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.BestMatchHover;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLAnnotationHover;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLAutoIndentStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCodeScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProcessor;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDoubleClickStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLUpperCaseFormattingStrategy;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private SQLEditor fEditor;
    private SQLCompletionProcessor fCompletionProcessor;
    private ISQLDBProposalsService fDBProposalsService;

    public SQLSourceViewerConfiguration(SQLEditor editor) {
        this.fEditor = editor;
        this.fCompletionProcessor = new SQLCompletionProcessor();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new SQLAnnotationHover((IEditorPart)this.getSQLEditor());
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        return "__dftl_partition_content_type".equals(contentType) ? new SQLAutoIndentStrategy() : new DefaultAutoIndentStrategy();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___sql_partitioning";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fCompletionProcessor = new SQLCompletionProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fCompletionProcessor, "__dftl_partition_content_type");
        ISQLDBProposalsService proposalsService = this.getDBProposalsService();
        if (proposalsService != null) {
            this.fCompletionProcessor.setDBProposalsService(proposalsService);
        }
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(12);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(SQLEditorPlugin.getDefault().getSQLColorProvider().getColor(new RGB(150, 150, 0)));
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setDocumentPartitioning("___sql_partitioning");
        SQLUpperCaseFormattingStrategy formattingStrategy = new SQLUpperCaseFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__dftl_partition_content_type");
        return formatter;
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SQLDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        SQLColorProvider colorProvider = this.getSQLEditor().getSQLColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        String docPartitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        reconciler.setDocumentPartitioning(docPartitioning);
        SQLCodeScanner sqlCodeScanner = new SQLCodeScanner(SQLEditorPlugin.getDefault().getSQLColorProvider());
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this.getSQLEditor().getConnectionInfo().getDatabaseVendorDefinitionId());
        if (factory != null) {
            sqlCodeScanner.setSQLSyntax(factory.getSQLService().getSQLSyntax());
        }
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)sqlCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_COMMENT_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "__sql_comment__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sql_comment__");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_QUOTED_LITERAL_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "__sql_quoted_literal__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sql_quoted_literal__");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_DELIMITED_IDENTIFIER_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "__sql_delimited_identifier__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sql_delimited_identifier__");
        return reconciler;
    }

    public SQLEditor getSQLEditor() {
        return this.fEditor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new BestMatchHover((IEditorPart)this.getSQLEditor());
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        if (this.fCompletionProcessor != null) {
            this.fCompletionProcessor.setDBProposalsService(dbProposalsService);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SQLPartitionScanner.SQL_PARTITION_TYPES;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"--", ""};
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

