/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLStorageDocumentProvider;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorDocumentSetupParticipant;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.ExecuteSQLAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.ExecuteSelectionSQLAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.ToggleCommentAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLEditorContentOutlinePage;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLOutlinePage;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLSourceViewer;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLSourceViewerConfiguration;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLUpdater;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SQLEditor
extends TextEditor
implements IPropertyChangeListener {
    public static final String PLUGIN_NAME = "org.eclipse.datatools.sqltools.sqleditor";
    public static final String HELP_CONTEXT_ID = "org.eclipse.datatools.sqltools.sqleditor.sqleditorhelp";
    protected AbstractSelectionChangedListener _fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();
    private SQLOutlinePage _fOutlinePage = null;
    private SQLUpdater _fSQLUpdater = null;
    private ProjectionSupport fProjectionSupport;
    private SQLEditorDocumentSetupParticipant fDocSetupParticipant;
    private ISQLDBProposalsService fDBProposalsService;
    private ParsingResult _parsingResult = null;

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = this.getResourceBundle();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        this.setAction("ContentFormat", (IAction)a);
        a = new ToggleCommentAction(bundle, "SQLEditor.action.toggle.commect.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction", (IAction)a);
        this.configureToggleCommentAction((IAction)a);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", (IAction)new ExecuteSQLAction(this));
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", (IAction)new ExecuteSelectionSQLAction(this));
        this.markAsStateDependentAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction", true);
        IActionBars bars = ((PartSite)this.getSite()).getActionBars();
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction"));
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction"));
    }

    protected SQLEditorContentOutlinePage createContentOutlinePage() {
        SQLEditorContentOutlinePage outlinePage = new SQLEditorContentOutlinePage(this.getDocumentProvider(), this);
        return outlinePage;
    }

    public void createPartControl(Composite parent) {
        this.setupDocumentProvider();
        super.createPartControl(parent);
        this.setProjectionSupport(this.createProjectionSupport());
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        viewer.doOperation(19);
        this.installSQLUpdater();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_ID);
    }

    protected ProjectionSupport createProjectionSupport() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projSupport.install();
        return projSupport;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        SQLSourceViewer viewer = new SQLSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        return viewer;
    }

    protected SQLSourceViewerConfiguration createSourceViewerConfiguration() {
        SQLSourceViewerConfiguration config = new SQLSourceViewerConfiguration(this);
        ISQLDBProposalsService proposalsService = this.getDBProposalsService();
        if (proposalsService != null) {
            config.setDBProposalsService(proposalsService);
        }
        return config;
    }

    public void dispose() {
        SQLOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.setInput(null);
        }
        this.stopSQLUpdater();
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.runUpdater();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.runUpdater();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.setupDocumentProvider();
        this.runUpdater();
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        IDocument doc;
        if (this._fSQLUpdater != null) {
            this._fSQLUpdater.removeMarkers();
            this.getSourceViewer().getDocument().removeDocumentListener((IDocumentListener)this._fSQLUpdater);
        }
        super.doSetInput(input);
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (docProvider != null && (doc = docProvider.getDocument((Object)input)) != null) {
            SQLEditorDocumentSetupParticipant docSetupParticipant = this.getDocumentSetupParticipant();
            docSetupParticipant.setup(doc);
        }
        if (input instanceof ISQLEditorInput) {
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            this.fDBProposalsService = new SQLDBProposalsService(sqlEditorInput.getConnectionInfo());
            SourceViewerConfiguration config = this.getSourceViewerConfiguration();
            if (config != null && config instanceof SQLSourceViewerConfiguration) {
                SQLSourceViewerConfiguration sqlConfig = (SQLSourceViewerConfiguration)config;
                sqlConfig.setDBProposalsService(this.fDBProposalsService);
            }
            this.setupDocumentProvider();
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            if (this._fSQLUpdater != null) {
                document.addDocumentListener((IDocumentListener)this._fSQLUpdater);
                this._fSQLUpdater.run();
            }
        }
        this.refreshConnectionStatus();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.sqleditor.open"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.sqleditor.source"));
        menu.add((IContributionItem)new Separator("group.sqleditor.execute"));
        menu.add((IContributionItem)new Separator("group.sqleditor.wizard"));
        menu.add((IContributionItem)new Separator("group.sqleditor.save"));
        menu.add((IContributionItem)new Separator("group.sqleditor.addition"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("group.sqleditor.source", this.getAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction"));
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ContentAssistProposal");
        this.addAction(menu, "ContentAssistTip");
        this.addAction(menu, "ContentFormat");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction");
        this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction");
    }

    public Object getAdapter(Class classForWhichAdapterNeeded) {
        ProjectionSupport projSupport;
        Object adapter = null;
        if (IContentOutlinePage.class.equals(classForWhichAdapterNeeded)) {
            if (this._fOutlinePage == null) {
                this._fOutlinePage = new SQLOutlinePage(this);
                this._fOutlineSelectionChangedListener.install(this._fOutlinePage);
                this.installSQLUpdater();
                this._fSQLUpdater.setOutlinePage(this._fOutlinePage);
            }
            adapter = this._fOutlinePage;
        } else if (adapter == null && (projSupport = this.getProjectionSupport()) != null) {
            adapter = projSupport.getAdapter(this.getSourceViewer(), classForWhichAdapterNeeded);
        }
        if (adapter == null) {
            adapter = super.getAdapter(classForWhichAdapterNeeded);
        }
        return adapter;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            return ((ISQLEditorInput)this.getEditorInput()).getConnectionInfo();
        }
        return SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            ISQLEditorConnectionInfo oldConnInfo = this.getConnectionInfo();
            ((ISQLEditorInput)this.getEditorInput()).setConnectionInfo(connInfo);
            IRunnableWithProgress progressOp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    SQLEditor.this.doSave(monitor);
                }
            };
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, progressOp);
            }
            catch (InvocationTargetException e) {
                Throwable targetExc = e.getTargetException();
                String title = NLS.bind((String)SQLEditorResources.EditorManager_operationFailed, (Object[])new Object[]{SQLEditorResources.Save});
                String message = targetExc.getMessage();
                message = message == null ? "" : message;
                Status status = new Status(2, PLUGIN_NAME, 0, message, targetExc);
                SQLEditorPlugin.getDefault().log((IStatus)status);
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)SQLEditorResources.common_error, (String)(title + ':' + message));
            }
            catch (InterruptedException e) {
                return;
            }
            if (connInfo != null && !connInfo.getDatabaseVendorDefinitionId().equals((Object)oldConnInfo.getDatabaseVendorDefinitionId())) {
                ((ISourceViewerExtension2)this.getSourceViewer()).unconfigure();
                SQLSourceViewerConfiguration configuration = this.createSourceViewerConfiguration();
                this.setSourceViewerConfiguration(configuration);
                this.getSourceViewer().configure((SourceViewerConfiguration)configuration);
                this.setInput(this.getEditorInput());
            }
            this.refreshActionStatus();
            this.refreshConnectionStatus();
            this._fSQLUpdater.run();
        }
    }

    public Database getDatabase() {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            return ((ISQLEditorInput)this.getEditorInput()).getConnectionInfo().getDatabase();
        }
        return null;
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    public String getDefaultSchemaName() {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            return ((ISQLEditorInput)this.getEditorInput()).getConnectionInfo().getDefaultSchemaName();
        }
        return null;
    }

    public SQLEditorDocumentSetupParticipant getDocumentSetupParticipant() {
        if (this.fDocSetupParticipant == null) {
            this.fDocSetupParticipant = new SQLEditorDocumentSetupParticipant();
        }
        return this.fDocSetupParticipant;
    }

    protected SQLOutlinePage getOutlinePage() {
        return this._fOutlinePage;
    }

    protected ProjectionSupport getProjectionSupport() {
        return this.fProjectionSupport;
    }

    public ResourceBundle getResourceBundle() {
        return SQLEditorResources.getResourceBundle();
    }

    public SQLColorProvider getSQLColorProvider() {
        return SQLEditorPlugin.getDefault().getSQLColorProvider();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider((IDocumentProvider)new SQLStorageDocumentProvider());
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Connection")) {
            this.refreshConnectionStatus();
        }
    }

    public void setDocumentSetupParticipant(SQLEditorDocumentSetupParticipant docSetupParticipant) {
        this.fDocSetupParticipant = docSetupParticipant;
    }

    public void setFocus() {
        super.setFocus();
        this.refreshConnectionStatus();
    }

    protected void setProjectionSupport(ProjectionSupport projSupport) {
        this.fProjectionSupport = projSupport;
    }

    protected void runUpdater() {
        if (this._fSQLUpdater != null) {
            this._fSQLUpdater.run();
        }
    }

    public ISQLEditorConnectionInfo requestConnectionFromUser() {
        return null;
    }

    public ISourceViewer getSV() {
        return this.getSourceViewer();
    }

    public void outlinePageClosed() {
        if (this._fOutlinePage != null) {
            this._fOutlineSelectionChangedListener.uninstall(this._fOutlinePage);
            this._fOutlinePage = null;
        }
    }

    private void stopSQLUpdater() {
        try {
            IPreferenceStore preferenceStore;
            this._fSQLUpdater.removeMarkers();
            this._fSQLUpdater.setOutlinePage(null);
            if (this.getSourceViewer().getDocument() != null) {
                this.getSourceViewer().getDocument().removeDocumentListener((IDocumentListener)this._fSQLUpdater);
            }
            if ((preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore()) != null) {
                preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this._fSQLUpdater);
            }
            this.getSite().getShell().getDisplay().timerExec(-1, (Runnable)this._fSQLUpdater);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void installSQLUpdater() {
        try {
            if (this._fSQLUpdater == null) {
                this._fSQLUpdater = new SQLUpdater(this);
                this.getSourceViewer().getDocument().addDocumentListener((IDocumentListener)this._fSQLUpdater);
                IPreferenceStore preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
                if (preferenceStore != null) {
                    preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this._fSQLUpdater);
                }
                this._fSQLUpdater.run();
            }
        }
        catch (Throwable e) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLEditor_error_while_trying_to_install_sql_updater, e);
        }
    }

    protected void setSelection(SimpleNode node) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        widget.setRedraw(false);
        if (node != null) {
            int offset = node.getStartOffset(viewer.getDocument());
            int length = node.getEndOffset(viewer.getDocument()) - offset;
            try {
                this.setHighlightRange(offset, length, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            viewer.revealRange(offset, length);
            viewer.setSelectedRange(offset, length);
        } else {
            this.resetHighlightRange();
            viewer.setSelectedRange(widget.getCaretOffset(), 0);
        }
        widget.setRedraw(true);
    }

    public ParsingResult getParsingResult() {
        return this._parsingResult;
    }

    public void setParsingResult(ParsingResult result) {
        this._parsingResult = result;
    }

    protected void setupDocumentProvider() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        DatabaseVendorDefinitionId vendorId = this.getConnectionInfo().getDatabaseVendorDefinitionId();
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)vendorId);
        SQLPartitionScanner _sqlPartitionSanner = new SQLPartitionScanner(factory.getSQLService().getSQLSyntax());
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)_sqlPartitionSanner, new String[]{"__sql_comment__", "__sql_multiline_comment", "__sql_quoted_literal__", "__sql_delimited_identifier__"});
            partitioner.connect(document);
            extension3.setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
        }
    }

    protected void refreshActionStatus() {
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        actionList.add(this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        actionList.add(this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction"));
        Iterator iterator = actionList.iterator();
        while (iterator.hasNext()) {
            IUpdate textEditorAction = (IUpdate)iterator.next();
            if (textEditorAction == null) continue;
            textEditorAction.update();
        }
    }

    public void refreshConnectionStatus() {
        IActionBars actionBars;
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null && (actionBars = editorSite.getActionBars()) != null) {
            IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            if (connInfo != null && connInfo.getConnectionProfile() != null) {
                statusLineMgr.setErrorMessage(null);
                String connStatus = connInfo.getConnectionProfile().getName();
                statusLineMgr.setMessage(connStatus);
            } else {
                String connStatus = SQLEditorResources.SQLEditor_connection_status_noConnection;
                statusLineMgr.setErrorMessage(connStatus);
            }
            actionBars.updateActionBars();
        }
    }

    public String getText() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        return document.get();
    }

    public String getSelectedText() {
        String sql = null;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (!selection.isEmpty() && selection.getText() != null && !selection.getText().equals("")) {
            sql = selection.getText();
        }
        return sql;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.datatools.sqltools.SQLEditorScope"});
    }

    public int getOrientation() {
        return 0x2000000;
    }

    private void configureToggleCommentAction(IAction action) {
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected class OutlineSelectionChangedListener
    extends AbstractSelectionChangedListener {
        protected OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            Object element = ((IStructuredSelection)selection).getFirstElement();
            SimpleNode node = element instanceof SimpleNode ? (SimpleNode)element : null;
            SQLEditor.this.setSelection(node);
        }
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }
}

