/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelPackage;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class InsertHelper {
    public static void addColumn(EditingDomain editDomain, QueryInsertStatement statement, Column column) {
        EList valuesRowList;
        ValueExpressionColumn addedColumnExpr;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, column});
        }
        if ((addedColumnExpr = TableHelper.getColumnExpressionForColumn((TableExpression)statement.getTargetTable(), (Column)column)) != null) {
            if (statement.getSourceQuery() != null) {
                statement.getTargetColumnList().add((Object)addedColumnExpr);
            } else {
                InsertHelper.addDefaultInsertValue(editDomain, statement, column);
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
        }
        if ((valuesRowList = statement.getSourceValuesRowList()).size() > 0) {
            valuesRowList.set(0, valuesRowList.get(0));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void removeColumn(QueryInsertStatement statement, Column column) {
        ValueExpressionColumn removedColumn = TableHelper.getColumnExpressionForColumn((TableExpression)statement.getTargetTable(), (Column)column);
        InsertHelper.removeColumn(statement, removedColumn);
    }

    public static void refresh(QueryInsertStatement insert) {
        if (insert != null) {
            insert.setSourceQuery(insert.getSourceQuery());
        }
    }

    public static void removeColumn(QueryInsertStatement statement, ValueExpressionColumn removedColumn) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, removedColumn});
        }
        if (removedColumn != null) {
            EList valuesRowList;
            EList columnList = statement.getTargetColumnList();
            int index = columnList.indexOf(removedColumn);
            statement.getTargetColumnList().remove((Object)removedColumn);
            if (index == -1) {
                int size = columnList.size();
                String removedColumnName = removedColumn.getName();
                int i = 0;
                while (i < size) {
                    ValueExpressionColumn column = (ValueExpressionColumn)columnList.get(i);
                    if (removedColumnName.equalsIgnoreCase(column.getName())) {
                        index = i;
                        columnList.remove(index);
                        break;
                    }
                    ++i;
                }
            }
            if (index != -1 && statement.getSourceQuery() == null) {
                EList valuesRowList2 = statement.getSourceValuesRowList();
                ValuesRow row = (ValuesRow)valuesRowList2.get(0);
                EList exprList = row.getExprList();
                exprList.remove(index);
                SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)statement));
            }
            if ((valuesRowList = statement.getSourceValuesRowList()).size() > 0) {
                valuesRowList.set(0, valuesRowList.get(0));
            }
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addDefaultInsertValue(EditingDomain editDomain, QueryInsertStatement statement, Column column) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{statement, column});
        }
        if (statement != null && column != null) {
            ValueExpressionDefaultValue expr;
            EList valuesRowList = statement.getSourceValuesRowList();
            if (valuesRowList.isEmpty()) {
                ValuesRow row = SQLQueryModelFactory.eINSTANCE.createValuesRow();
                Command addRowCmd = AddCommand.create((EditingDomain)editDomain, (Object)statement, (Object)SQLQueryModelPackage.eINSTANCE.getQueryInsertStatement_SourceValuesRowList(), (Object)row);
                addRowCmd.execute();
            } else {
                ValuesRow row = (ValuesRow)valuesRowList.get(0);
            }
            TableInDatabase tableExpr = statement.getTargetTable();
            ValueExpressionColumn columnValue = TableHelper.getColumnExpressionForColumn((TableExpression)tableExpr, (Column)column);
            Command addColCmd = AddCommand.create((EditingDomain)editDomain, (Object)statement, (Object)SQLQueryModelPackage.eINSTANCE.getQueryInsertStatement_TargetColumnList(), (Object)columnValue);
            addColCmd.execute();
            String defaultValue = column.getDefaultValue();
            if (defaultValue != null) {
                expr = SQLQueryModelFactory.eINSTANCE.createValueExpressionDefaultValue();
            } else if (column.isNullable()) {
                expr = SQLQueryModelFactory.eINSTANCE.createValueExpressionNullValue();
            } else {
                expr = SQLQueryModelFactory.eINSTANCE.createValueExpressionSimple();
                defaultValue = ExpressionHelper.getDefaultValueForColumn(column);
                ((ValueExpressionSimple)expr).setValue(defaultValue);
            }
            Command addExprCmd = AddCommand.create((EditingDomain)editDomain, (Object)statement.getSourceValuesRowList().get(0), (Object)SQLQueryModelPackage.eINSTANCE.getValuesRow_ExprList(), (Object)expr);
            addExprCmd.execute();
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addInsertQuery(QueryInsertStatement insertStmt) {
        QueryExpressionRoot queryExpr = SQLQueryModelFactory.eINSTANCE.createQueryExpressionRoot();
        insertStmt.setSourceQuery(queryExpr);
    }

    public static void clearStatementContents(QueryInsertStatement stmt) {
        if (stmt != null) {
            InsertHelper.removeTableFromStatement(stmt);
            stmt.setSourceQuery(null);
            stmt.setName(null);
            stmt.setLabel(null);
        }
    }

    public static void removeAllColumnsAndValues(QueryInsertStatement stmt) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{stmt});
        }
        if (stmt != null) {
            EList colList = stmt.getTargetColumnList();
            colList.clear();
            EList valList = stmt.getSourceValuesRowList();
            valList.clear();
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void updateInsertValueForColumn(QueryInsertStatement insertStmt, ValueExpressionColumn column, QueryValueExpression valueExpr) {
        EList columnList;
        int columnPosition;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{insertStmt, column});
        }
        if ((columnPosition = (columnList = insertStmt.getTargetColumnList()).indexOf(column)) != -1) {
            ValuesRow valuesRow;
            EList exprList;
            EList valuesRowList = insertStmt.getSourceValuesRowList();
            if (valuesRowList != null && valuesRowList.size() > 0 && (exprList = (valuesRow = (ValuesRow)valuesRowList.get(0)).getExprList()) != null) {
                exprList.set(columnPosition, valueExpr);
            }
            if (valuesRowList.size() > 0) {
                valuesRowList.set(0, valuesRowList.get(0));
            }
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)insertStmt));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void addInsertColumnValuePair(QueryInsertStatement insertStmt, ValueExpressionColumn column, QueryValueExpression valueExpr) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{insertStmt, column, valueExpr});
        }
        EList columnList = insertStmt.getTargetColumnList();
        columnList.add(column);
        EList valuesRowList = insertStmt.getSourceValuesRowList();
        if (valuesRowList.size() == 0) {
            ValuesRow row = SQLQueryModelFactory.eINSTANCE.createValuesRow();
            valuesRowList.add(row);
        }
        ValuesRow valuesRow = (ValuesRow)valuesRowList.get(0);
        EList exprList = valuesRow.getExprList();
        exprList.add(valueExpr);
        if (valuesRowList.size() > 0) {
            valuesRowList.set(0, valuesRowList.get(0));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Modified statement: " + StatementHelper.getSQLSourceUnformatted((SQLQueryObject)insertStmt));
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static void replaceColumn(QueryInsertStatement insertStmt, ValueExpressionColumn oldColumn, ValueExpressionColumn newColumn) {
        EList valuesRowList;
        EList columnList;
        int columnIndex;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{insertStmt, oldColumn, newColumn});
        }
        if ((columnIndex = (columnList = insertStmt.getTargetColumnList()).indexOf(oldColumn)) != -1) {
            columnList.set(columnIndex, newColumn);
        }
        if ((valuesRowList = insertStmt.getSourceValuesRowList()).size() > 0) {
            valuesRowList.set(0, valuesRowList.get(0));
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public static ValueExpressionColumn getColumnExpressionForName(QueryInsertStatement insertStmt, String columnName) {
        ValueExpressionColumn column = null;
        boolean found = false;
        Iterator colItr = insertStmt.getTargetColumnList().iterator();
        while (colItr.hasNext() && !found) {
            ValueExpressionColumn tempColumn = (ValueExpressionColumn)colItr.next();
            if (!tempColumn.getName().equals(columnName)) continue;
            column = tempColumn;
            found = true;
        }
        return column;
    }

    public static QueryValueExpression getInsertValueforColumn(QueryInsertStatement insertStmt, ValueExpressionColumn colExpr) {
        QueryValueExpression valueExpr = null;
        EList valuesRowList = insertStmt.getSourceValuesRowList();
        if (valuesRowList != null && !valuesRowList.isEmpty()) {
            EList exprList;
            ValuesRow valueRow;
            int colIndex;
            EList targetColList = insertStmt.getTargetColumnList();
            if (targetColList.isEmpty()) {
                targetColList = insertStmt.getTargetTable().getColumnList();
            }
            if ((colIndex = targetColList.indexOf(colExpr)) >= 0 && (valueRow = (ValuesRow)valuesRowList.get(0)) != null && !(exprList = valueRow.getExprList()).isEmpty()) {
                valueExpr = (QueryValueExpression)exprList.get(colIndex);
            }
        }
        return valueExpr;
    }

    public static void addOrReplaceTargetTable(TableInDatabase targetTable, QueryInsertStatement stmt) {
        TableInDatabase currentTableExpr = stmt.getTargetTable();
        if (targetTable != currentTableExpr) {
            InsertHelper.removeTableFromStatement(stmt);
            stmt.setTargetTable(targetTable);
        }
    }

    public static void removeTableFromStatement(QueryInsertStatement statement) {
        statement.getTargetColumnList().clear();
        statement.getSourceValuesRowList().clear();
        statement.setTargetTable(null);
    }

    public static void replaceStatementContents(QueryInsertStatement oldStmt, QueryInsertStatement newStmt) {
        if (oldStmt != null && newStmt != null) {
            oldStmt.setLabel(newStmt.getLabel());
            oldStmt.setName(newStmt.getName());
            oldStmt.setSourceInfo(newStmt.getSourceInfo());
            oldStmt.setSourceQuery(newStmt.getSourceQuery());
            oldStmt.setTargetTable(newStmt.getTargetTable());
            InsertHelper.removeAllColumnsAndValues(oldStmt);
            EList oldList = oldStmt.getTargetColumnList();
            EList newList = newStmt.getTargetColumnList();
            oldList.addAll(newList);
            oldList = oldStmt.getSourceValuesRowList();
            newList = newStmt.getSourceValuesRowList();
            oldList.addAll(newList);
        }
    }

    public static void setTargetTable(QueryInsertStatement statement, TableInDatabase targetTable) {
        if (statement != null) {
            statement.setTargetTable(targetTable);
        }
    }
}

