/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.Modifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.FullSelectTableElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect.RemoveQueryGroupAction;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.WorkbenchHelp;

public class FullSelectGridViewer
extends NavigableTableViewer
implements IMenuListener {
    protected SQLDomainModel domainModel;
    protected Table table;
    protected TableColumn c1;
    protected TableColumn c2;
    protected ComboBoxCellEditor statementCellEditor;
    protected ComboBoxCellEditor operatorCellEditor;
    protected FullSelectGridLabelProvider fullSelectLabelProvider;
    protected FullSelectGridContentProvider fullSelectGridContentProvider;
    static /* synthetic */ Class class$0;

    public FullSelectGridViewer(SQLDomainModel domainModel, Composite parent) {
        super(new Table(parent, 65538));
        this.domainModel = domainModel;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)ViewUtility.createFill());
        WorkbenchHelp.setHelp((Control)this.table, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqdf0010");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        this.table.setLayout((Layout)layout);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_STATEMENT);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_FULL_SELECT_OPERATOR);
        String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_EXPRESSION, (String)SQLBuilderConstants.P_STATEMENT_OPERATOR};
        this.setColumnProperties(columnProperties);
        this.createComboBoxItemsBasedOnVendor();
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.operatorCellEditor;
        CellEditor[] editors = cellEditorArray;
        this.setCellEditors(editors);
        this.setCellModifier(new Modifier());
        this.fullSelectGridContentProvider = new FullSelectGridContentProvider(domainModel.getAdapterFactory());
        this.setContentProvider((IContentProvider)this.fullSelectGridContentProvider);
        this.fullSelectLabelProvider = new FullSelectGridLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.fullSelectLabelProvider);
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void menuAboutToShow(IMenuManager menu) {
        RemoveQueryGroupAction removeQueryGroupAction = new RemoveQueryGroupAction(this);
        menu.add((IAction)removeQueryGroupAction);
    }

    private void createComboBoxItemsBasedOnVendor() {
        VendorHelper vendor = this.domainModel.getVendor();
        this.operatorCellEditor = new ComboBoxCellEditor((Composite)this.table, null);
        this.statementCellEditor = new ComboBoxCellEditor((Composite)this.table, null);
        ArrayList<LabelValuePair> list = new ArrayList<LabelValuePair>();
        list.add(new LabelValuePair("UNION", "UNION"));
        list.add(new LabelValuePair("UNION ALL", "UNION ALL"));
        if (vendor.isDB2() && !vendor.isDB2UDBOS390()) {
            list.add(new LabelValuePair("INTERSECT", "INTERSECT"));
            list.add(new LabelValuePair("INTERSECT ALL", "INTERSECT ALL"));
            list.add(new LabelValuePair("EXCEPT", "EXCEPT"));
            list.add(new LabelValuePair("EXCEPT ALL", "EXCEPT ALL"));
        } else if (vendor.isOracle()) {
            list.add(new LabelValuePair("INTERSECT", "INTERSECT"));
            list.add(new LabelValuePair("MINUS", "MINUS"));
        }
        LabelValuePair[] operatorComboItems = new LabelValuePair[list.size()];
        list.toArray(operatorComboItems);
        this.operatorCellEditor.createItems(operatorComboItems);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (input instanceof QueryCombined) {
            this.updateCellEditorContent();
        }
        super.inputChanged(input, oldInput);
    }

    protected void updateCellEditorContent() {
        ArrayList<LabelValuePair> contentsHolder = new ArrayList<LabelValuePair>();
        contentsHolder.add(new LabelValuePair(SQLBuilderConstants.P_ADD_SELECT, SQLBuilderConstants.P_ADD_SELECT));
        contentsHolder.add(new LabelValuePair(SQLBuilderConstants.P_ADD_FULLSELECT, SQLBuilderConstants.P_ADD_FULLSELECT));
        VendorHelper vendor = this.domainModel.getVendor();
        if (vendor.isDB2() && !vendor.isDB2UDBOS390_V6()) {
            contentsHolder.add(new LabelValuePair(SQLBuilderConstants.P_ADD_WITH, SQLBuilderConstants.P_ADD_WITH));
            contentsHolder.add(new LabelValuePair(SQLBuilderConstants.P_ADD_VALUES, SQLBuilderConstants.P_ADD_VALUES));
        }
        LabelValuePair[] statementComboItems = new LabelValuePair[contentsHolder.size()];
        contentsHolder.toArray(statementComboItems);
        this.statementCellEditor.createItems(statementComboItems);
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.table.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            Composite control = this.table.getParent();
            this.table.setBackground(control.getBackground());
        }
    }

    public class FullSelectGridContentProvider
    extends GridContentProvider {
        public FullSelectGridContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object property) {
            QueryExpressionBody queryExprBody;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IStructuredItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterFactory.adapt(property, (Object)clazz);
            this.tableElements = new Vector();
            if (property instanceof QueryExpressionBody && (queryExprBody = (QueryExpressionBody)property) instanceof QueryCombined) {
                QueryCombined queryCombined = (QueryCombined)queryExprBody;
                QueryCombinedOperator operator = queryCombined.getCombinedOperator();
                QueryExpressionBody leftChild = queryCombined.getLeftQuery();
                this.createNewFullSelectElement(leftChild, operator, queryCombined);
                QueryExpressionBody rightChild = queryCombined.getRightQuery();
                this.createNewFullSelectElement(rightChild, null, queryCombined);
            }
            return this.tableElements.toArray();
        }

        private void createNewFullSelectElement(QueryExpressionBody queryExprBody, QueryCombinedOperator operator, QueryCombined parent) {
            FullSelectTableElement element = new FullSelectTableElement(queryExprBody, operator, parent);
            this.tableElements.add(element);
        }
    }

    class FullSelectGridLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FullSelectGridLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof FullSelectTableElement) {
                FullSelectTableElement element = (FullSelectTableElement)object;
                return element.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex == 0) {
                boolean cfr_ignored_0 = object instanceof FullSelectTableElement;
            }
            return null;
        }
    }
}

