/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.execute;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.StringUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterWizardDialog;
import org.eclipse.swt.widgets.Display;

public class ParameterMarkers {
    QueryStatement sqlStatement;
    boolean continueExecution;
    Vector markerValues = new Vector();

    public ParameterMarkers(QueryStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.continueExecution = true;
    }

    public boolean getContinueExecution() {
        return this.continueExecution;
    }

    public Vector getMarkerValues() {
        return this.markerValues;
    }

    public String substituteParameters() {
        List paramMarkerList = StatementHelper.getAllParameterMarkersInQueryStatement((QueryStatement)this.sqlStatement);
        List allVarList = StatementHelper.getAllVariablesInQueryStatement((QueryStatement)this.sqlStatement);
        Vector paramVec = new Vector();
        paramVec.addAll(allVarList);
        String sqlString = StatementHelper.getSQLForExecution((SQLQueryObject)this.sqlStatement);
        if (paramVec.size() > 0) {
            ParameterWizard wizard = new ParameterWizard(paramVec);
            Vector valueMarkers = new Vector();
            ParameterWizardDialog wizardDialog = new ParameterWizardDialog(Display.getCurrent().getActiveShell(), wizard);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.create();
            int result = wizardDialog.open();
            if (result == 0) {
                this.continueExecution = true;
                valueMarkers = wizard.getParameterMarkers();
                String marker = "";
                String value = "";
                int i = 0;
                while (i < paramVec.size()) {
                    if (paramVec.elementAt(i) instanceof QueryValueExpression) {
                        QueryValueExpression expr = (QueryValueExpression)paramVec.elementAt(i);
                        if (expr != null) {
                            marker = expr.getSQL();
                        }
                    } else {
                        marker = "";
                    }
                    value = (String)valueMarkers.elementAt(i);
                    this.markerValues.add(value);
                    sqlString = StringUtility.change(sqlString, marker, value, 0, 1);
                    ++i;
                }
            } else {
                sqlString = "";
                this.continueExecution = false;
            }
            if (paramMarkerList.size() > 0) {
                Iterator paramMarkerListIter = paramMarkerList.iterator();
                while (paramMarkerListIter.hasNext()) {
                    ValueExpressionVariable var = (ValueExpressionVariable)paramMarkerListIter.next();
                    var.setName(null);
                }
                SelectHelper.refresh((SQLQueryObject)this.sqlStatement);
            }
        }
        return sqlString;
    }
}

