/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DBVersionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DatabaseHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.FunctionHelperDB2;

public class FunctionHelper {
    public static final String CAT_LABEL_ALL_FUNCTIONS = Messages._UI_FCN_ALL;
    public static final String CAT_LABEL_AGGREGATE_FUNCTIONS = Messages._UI_FCN_COLUMN;
    public static final String CAT_LABEL_CONVERSION_FUNCTIONS = Messages._UI_FCN_CONVERSION;
    public static final String CAT_LABEL_DATETIME_FUNCTIONS = Messages._UI_FCN_DATE_TIME;
    public static final String CAT_LABEL_NUMERIC_FUNCTIONS = Messages._UI_FCN_MATH;
    public static final String CAT_LABEL_SCALAR_FUNCTIONS = Messages._UI_FCN_SCALAR;
    public static final String CAT_LABEL_SPECIAL_REGISTERS = Messages._UI_FCN_SPECIAL_REG;
    public static final String CAT_LABEL_STRING_FUNCTIONS = Messages._UI_FCN_TEXT;
    public static final String CAT_LABEL_USER_DEFINED_FUNCTIONS = Messages._UI_FCN_UDF;
    public static final int ALL_LOCATION_OMITTED = 0;
    public static final int ALL_LOCATION_TOP = 1;
    public static final int ALL_LOCATION_BOTTOM = 2;
    public static final int ALL_LOCATION_SORTED = 3;
    private static Map gDBToFuncHelperMap = Collections.synchronizedMap(new HashMap());
    private Database fDB;
    private DBVersionHelper fVersionHelper;
    protected List fAllBuiltinFunctionNamesList;
    protected List fAggregateFunctionNamesList;
    protected List fConversionFunctionNamesList;
    protected List fDatetimeFunctionNamesList;
    protected List fNumericFunctionNamesList;
    protected List fScalarFunctionNamesList;
    protected List fSpecialRegisterNamesList;
    protected List fStringFunctionNamesList;
    protected List fUserDefinedFunctionNamesList;
    protected List fUserDefinedFunctionObjectsList;
    protected Map fFuncNameToSigListMap;
    protected static final int SIGLIST_000 = 0;
    protected static final int SIGLIST_010 = 10;
    protected static final int SIGLIST_020 = 20;
    protected static final int SIGLIST_030 = 30;
    protected static final int SIGLIST_040 = 40;
    protected static final int SIGLIST_050 = 50;
    protected static final int SIGLIST_060 = 60;
    protected static final int SIGLIST_070 = 70;
    protected static final int SIGLIST_080 = 80;
    protected static final int SIGLIST_090 = 90;
    protected static final int SIGLIST_100 = 100;
    protected static final int SIGLIST_110 = 110;
    protected static final int SIGLIST_120 = 120;
    protected static final int SIGLIST_130 = 130;
    protected static final int SIGLIST_140 = 140;
    protected static final int SIGLIST_150 = 150;
    protected static final int SIGLIST_160 = 160;
    protected static final int SIGLIST_170 = 170;
    protected static final int SIGLIST_180 = 180;
    protected static final int SIGLIST_190 = 190;
    protected static final int SIGLIST_200 = 200;
    protected static final int SIGLIST_210 = 210;
    protected static final int SIGLIST_220 = 220;
    protected static final int SIGLIST_230 = 230;
    protected static final int SIGLIST_240 = 240;
    protected static final int SIGLIST_250 = 250;
    protected static final int SIGLIST_260 = 260;
    protected static final int SIGLIST_270 = 270;
    protected static final int SIGLIST_280 = 280;
    protected static final int SIGLIST_290 = 290;
    protected static final int SIGLIST_300 = 300;
    protected static final int SIGLIST_310 = 310;
    protected static final int SIGLIST_320 = 320;
    protected static final int SIGLIST_330 = 330;
    protected static final int SIGLIST_340 = 340;
    protected static final int SIGLIST_350 = 350;
    protected static final int SIGLIST_360 = 360;
    protected static final int SIGLIST_370 = 370;
    protected static final int SIGLIST_380 = 380;
    protected static final int SIGLIST_390 = 390;
    protected static final int SIGLIST_400 = 400;
    protected static final int SIGLIST_410 = 410;
    protected static final int SIGLIST_420 = 420;
    protected static final int SIGLIST_430 = 430;
    protected static final int SIGLIST_440 = 440;
    protected static final int SIGLIST_450 = 450;
    protected static final int SIGLIST_460 = 460;
    protected static final int SIGLIST_470 = 470;
    protected static final int SIGLIST_480 = 480;
    protected static final int SIGLIST_490 = 490;
    protected static final int SIGLIST_500 = 500;
    protected static final int SIGLIST_510 = 510;
    protected static final int SIGLIST_520 = 520;
    protected static final int SIGLIST_530 = 530;
    protected static final int SIGLIST_540 = 540;
    protected static final int SIGLIST_550 = 550;
    protected static final int SIGLIST_560 = 560;
    protected static final int SIGLIST_570 = 570;
    protected static final int SIGLIST_580 = 580;
    protected static final int SIGLIST_590 = 590;
    protected static final int SIGLIST_600 = 600;
    protected static final int SIGLIST_610 = 610;
    protected static final int SIGLIST_620 = 620;
    protected static final int SIGLIST_630 = 630;
    protected static final int SIGLIST_640 = 640;
    protected static final int SIGLIST_650 = 650;
    protected static final int SIGLIST_660 = 660;
    protected static final int SIGLIST_670 = 670;
    protected static final int SIGLIST_680 = 680;
    protected static final int SIGLIST_690 = 690;
    protected static final int SIGLIST_700 = 700;
    protected static final int SIGLIST_710 = 710;
    protected static final int SIGLIST_720 = 720;
    protected static final int SIGLIST_730 = 730;
    protected static final int SIGLIST_740 = 740;
    protected static final int SIGLIST_750 = 750;
    protected static final int SIGLIST_760 = 760;
    protected static final int SIGLIST_770 = 770;
    protected static final int SIGLIST_780 = 780;
    protected static final int SIGLIST_790 = 790;
    protected static final int SIGLIST_800 = 800;
    protected static final int SIGLIST_810 = 810;
    protected static final int SIGLIST_820 = 820;
    protected static final int SIGLIST_830 = 830;
    protected static final int SIGLIST_840 = 840;
    protected static final int SIGLIST_850 = 850;
    protected static final int SIGLIST_860 = 860;
    protected static final int SIGLIST_870 = 870;
    protected static final int SIGLIST_880 = 880;
    protected static final int SIGLIST_890 = 890;
    protected static final int SIGLIST_900 = 900;
    protected static final int SIGLIST_910 = 910;
    protected static final int SIGLIST_920 = 920;
    protected static final int SIGLIST_930 = 930;
    protected static final int SIGLIST_940 = 940;
    protected static final int SIGLIST_950 = 950;
    protected static final int SIGLIST_960 = 960;
    protected static final int SIGLIST_970 = 970;
    protected static final int SIGLIST_980 = 980;
    protected static final int SIGLIST_990 = 990;
    protected static final int SIGLIST_1000 = 1000;
    protected static final int SIGLIST_1010 = 1010;
    protected static final int SIGLIST_1020 = 1020;
    protected static final int SIGLIST_1030 = 1030;
    protected static final int SIGLIST_1040 = 1040;
    protected static final int SIGLIST_1050 = 1050;
    protected static final int SIGLIST_1060 = 1060;
    protected static final int SIGLIST_1070 = 1070;
    protected static final int SIGLIST_1080 = 1080;
    protected static final int SIGLIST_1090 = 1090;
    protected static final int SIGLIST_1100 = 1100;
    protected static final int SIGLIST_1110 = 1110;
    protected static final int SIGLIST_1120 = 1120;
    protected static final int SIGLIST_1130 = 1130;
    protected static final int SIGLIST_1140 = 1140;
    protected static final int SIGLIST_1150 = 1150;
    protected static final int SIGLIST_1160 = 1160;
    protected static final int SIGLIST_1170 = 1170;
    protected static final int SIGLIST_1180 = 1180;
    protected static final int SIGLIST_1190 = 1190;
    protected static final int SIGLIST_1200 = 1200;
    protected static final int SIGLIST_1210 = 1210;
    protected static final int SIGLIST_1220 = 1220;
    protected static final int SIGLIST_1230 = 1230;
    protected static final int SIGLIST_1240 = 1240;
    protected static final int SIGLIST_1250 = 1250;
    protected static final int SIGLIST_1260 = 1260;
    protected static final int SIGLIST_1270 = 1270;
    protected static final int SIGLIST_1280 = 1280;
    protected static final int SIGLIST_1290 = 1290;
    protected static final int SIGLIST_1300 = 1300;
    protected static final int SIGLIST_1310 = 1310;
    protected static final int SIGLIST_1320 = 1320;
    protected static final int SIGLIST_1330 = 1330;
    protected static final int SIGLIST_1340 = 1340;
    protected static final int SIGLIST_1350 = 1350;
    protected static final int SIGLIST_1360 = 1360;
    protected static final int SIGLIST_1370 = 1370;
    protected static final int SIGLIST_1380 = 1380;
    protected static final int SIGLIST_1390 = 1390;
    protected static final int SIGLIST_1400 = 1400;
    protected static final int SIGLIST_1410 = 1410;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FunctionHelper getInstance(Database db) {
        FunctionHelper funcHelper = null;
        if (db != null) {
            Map map = gDBToFuncHelperMap;
            synchronized (map) {
                funcHelper = (FunctionHelper)gDBToFuncHelperMap.get(db);
                if (funcHelper == null) {
                    DBVersionHelper versionHelper = new DBVersionHelper(db);
                    if (versionHelper.isDB2()) {
                        funcHelper = new FunctionHelperDB2(db);
                    }
                    if (funcHelper != null) {
                        gDBToFuncHelperMap.put(db, funcHelper);
                    }
                }
            }
        }
        return funcHelper;
    }

    protected static final String[] joinArrays(String[] strArray1, String[] strArray2) {
        int i = 0;
        String[] strArray3 = new String[strArray1.length + strArray2.length];
        i = 0;
        while (i < strArray1.length) {
            strArray3[i] = strArray1[i];
            ++i;
        }
        int j = 0;
        while (j < strArray2.length) {
            strArray3[i] = strArray2[j];
            ++i;
            ++j;
        }
        return strArray3;
    }

    protected static final String[] mergeSortArrays(String[][] arrayArray) {
        String[] mergedArray = null;
        int arrayCount = arrayArray.length;
        if (arrayCount > 0) {
            String[] tempArray = arrayArray[0];
            List<String> tempList = Arrays.asList(tempArray);
            ArrayList<String> mergedList = new ArrayList<String>(tempList);
            int i = 1;
            while (i < arrayCount) {
                tempArray = arrayArray[i];
                tempList = Arrays.asList(tempArray);
                mergedList.addAll(tempList);
                ++i;
            }
            Collections.sort(mergedList);
            LinkedHashSet<String> mergedListNoDups = new LinkedHashSet<String>(mergedList);
            int listLen = mergedListNoDups.size();
            mergedArray = mergedListNoDups.toArray(new String[listLen]);
        }
        return mergedArray;
    }

    protected FunctionHelper() {
    }

    public FunctionHelper(Database db) {
        this.fDB = db;
        this.fVersionHelper = new DBVersionHelper(db);
        this.initialize();
    }

    public Database getDatabase() {
        return this.fDB;
    }

    public List getFunctionCategories(int allCatLocation) {
        ArrayList<String> catList = new ArrayList<String>();
        catList.addAll(this.getBuiltinFunctionCategories());
        catList.add(CAT_LABEL_USER_DEFINED_FUNCTIONS);
        if (allCatLocation == 3) {
            catList.add(CAT_LABEL_ALL_FUNCTIONS);
        }
        Collections.sort(catList);
        if (allCatLocation == 1) {
            catList.add(0, CAT_LABEL_ALL_FUNCTIONS);
        } else if (allCatLocation == 2) {
            catList.add(CAT_LABEL_ALL_FUNCTIONS);
        }
        return catList;
    }

    protected List getBuiltinFunctionCategories() {
        ArrayList<String> catList = new ArrayList<String>();
        catList.add(CAT_LABEL_AGGREGATE_FUNCTIONS);
        catList.add(CAT_LABEL_CONVERSION_FUNCTIONS);
        catList.add(CAT_LABEL_DATETIME_FUNCTIONS);
        catList.add(CAT_LABEL_NUMERIC_FUNCTIONS);
        catList.add(CAT_LABEL_SCALAR_FUNCTIONS);
        catList.add(CAT_LABEL_SPECIAL_REGISTERS);
        catList.add(CAT_LABEL_STRING_FUNCTIONS);
        return catList;
    }

    public List getFunctionNames(String category) {
        List funcNames = new ArrayList();
        if (category.equals(CAT_LABEL_ALL_FUNCTIONS)) {
            funcNames = this.getAllBuiltinFunctionNames();
        } else if (category.equals(CAT_LABEL_AGGREGATE_FUNCTIONS)) {
            funcNames = this.getAggregateFunctionNames();
        } else if (category.equals(CAT_LABEL_CONVERSION_FUNCTIONS)) {
            funcNames = this.getConversionFunctionNames();
        } else if (category.equals(CAT_LABEL_DATETIME_FUNCTIONS)) {
            funcNames = this.getDatetimeFunctionNames();
        } else if (category.equals(CAT_LABEL_NUMERIC_FUNCTIONS)) {
            funcNames = this.getNumericFunctionNames();
        } else if (category.equals(CAT_LABEL_SCALAR_FUNCTIONS)) {
            funcNames = this.getScalarFunctionNames();
        } else if (category.equals(CAT_LABEL_SPECIAL_REGISTERS)) {
            funcNames = this.getSpecialRegisterNames();
        } else if (category.equals(CAT_LABEL_STRING_FUNCTIONS)) {
            funcNames = this.getStringFunctionNames();
        } else if (category.equals(CAT_LABEL_USER_DEFINED_FUNCTIONS)) {
            funcNames = this.getUserDefinedFunctionNames();
        }
        return funcNames;
    }

    public List getAllBuiltinFunctionNames() {
        if (this.fAllBuiltinFunctionNamesList == null) {
            this.initAllBuiltinFunctions();
        }
        return this.fAllBuiltinFunctionNamesList;
    }

    public List getAggregateFunctionNames() {
        if (this.fAggregateFunctionNamesList == null) {
            this.initAggregateFunctions();
        }
        return this.fAggregateFunctionNamesList;
    }

    public List getConversionFunctionNames() {
        if (this.fConversionFunctionNamesList == null) {
            this.initConversionFunctions();
        }
        return this.fConversionFunctionNamesList;
    }

    public List getDatetimeFunctionNames() {
        if (this.fDatetimeFunctionNamesList == null) {
            this.initDatetimeFunctions();
        }
        return this.fDatetimeFunctionNamesList;
    }

    public List getNumericFunctionNames() {
        if (this.fNumericFunctionNamesList == null) {
            this.initNumericFunctions();
        }
        return this.fNumericFunctionNamesList;
    }

    public List getScalarFunctionNames() {
        if (this.fScalarFunctionNamesList == null) {
            this.initScalarFunctions();
        }
        return this.fScalarFunctionNamesList;
    }

    public List getSpecialRegisterNames() {
        if (this.fSpecialRegisterNamesList == null) {
            this.initSpecialRegisters();
        }
        return this.fSpecialRegisterNamesList;
    }

    public List getStringFunctionNames() {
        if (this.fStringFunctionNamesList == null) {
            this.initStringFunctions();
        }
        return this.fStringFunctionNamesList;
    }

    public List getUserDefinedFunctionNames() {
        if (this.fUserDefinedFunctionNamesList == null) {
            this.initUserDefinedFunctions();
        }
        return this.fUserDefinedFunctionNamesList;
    }

    public String[][] getFunctionSignatures(String functionName) {
        String[][] sigArray = new String[0][0];
        Integer sigListIndex = (Integer)this.fFuncNameToSigListMap.get(functionName);
        if (sigListIndex != null) {
            int sigListIndexInt = sigListIndex;
            sigArray = this.getFunctionSignatures(sigListIndexInt);
        } else {
            sigArray = this.getUserDefinedFunctionSignatures(functionName);
        }
        return sigArray;
    }

    protected String[][] getFunctionSignatures(int sigListNum) {
        String[][] list = new String[0][0];
        return list;
    }

    protected String[][] getUserDefinedFunctionSignatures(String functionName) {
        String[][] list = new String[0][0];
        int listIndex = this.fUserDefinedFunctionNamesList.indexOf(functionName);
        return list;
    }

    public boolean getIsFunctionAllowingStar(String funcName) {
        boolean isStarFunc = false;
        if (funcName.equalsIgnoreCase("COUNT") || funcName.equalsIgnoreCase("COUNT_BIG")) {
            isStarFunc = true;
        }
        return isStarFunc;
    }

    protected boolean getIsSystemSchema(Schema schema) {
        boolean isSysSchema = false;
        String schemaName = schema.getName().toUpperCase();
        if (schemaName.startsWith("SYS")) {
            isSysSchema = true;
        }
        return isSysSchema;
    }

    protected DBVersionHelper getVersionHelper() {
        return this.fVersionHelper;
    }

    protected void initialize() {
        this.fFuncNameToSigListMap = new HashMap();
    }

    protected void initAllBuiltinFunctions() {
        this.fAllBuiltinFunctionNamesList = new ArrayList();
        List allCatList = this.getFunctionCategories(0);
        Iterator allCatListIter = allCatList.iterator();
        while (allCatListIter.hasNext()) {
            String catLabel = (String)allCatListIter.next();
            if (catLabel.equals(CAT_LABEL_USER_DEFINED_FUNCTIONS)) continue;
            List nameList = this.getFunctionNames(catLabel);
            this.fAllBuiltinFunctionNamesList.addAll(nameList);
        }
        Collections.sort(this.fAllBuiltinFunctionNamesList);
        LinkedHashSet allFuncNameSet = new LinkedHashSet(this.fAllBuiltinFunctionNamesList);
        this.fAllBuiltinFunctionNamesList.clear();
        this.fAllBuiltinFunctionNamesList.addAll(allFuncNameSet);
    }

    protected void initAggregateFunctions() {
        this.fAggregateFunctionNamesList = new ArrayList();
    }

    protected void initConversionFunctions() {
        this.fConversionFunctionNamesList = new ArrayList();
    }

    protected void initDatetimeFunctions() {
        this.fDatetimeFunctionNamesList = new ArrayList();
    }

    protected void initNumericFunctions() {
        this.fNumericFunctionNamesList = new ArrayList();
    }

    protected void initScalarFunctions() {
        this.fScalarFunctionNamesList = new ArrayList();
        this.fScalarFunctionNamesList.addAll(this.getConversionFunctionNames());
        this.fScalarFunctionNamesList.addAll(this.getDatetimeFunctionNames());
        this.fScalarFunctionNamesList.addAll(this.getNumericFunctionNames());
        this.fScalarFunctionNamesList.addAll(this.getStringFunctionNames());
        Collections.sort(this.fScalarFunctionNamesList);
        LinkedHashSet scalarFuncNameSet = new LinkedHashSet(this.fScalarFunctionNamesList);
        this.fScalarFunctionNamesList.clear();
        this.fScalarFunctionNamesList.addAll(scalarFuncNameSet);
    }

    protected void initSpecialRegisters() {
        this.fSpecialRegisterNamesList = new ArrayList();
    }

    protected void initStringFunctions() {
        this.fStringFunctionNamesList = new ArrayList();
    }

    protected void initUserDefinedFunctions() {
        Schema schema;
        this.fUserDefinedFunctionNamesList = new ArrayList();
        this.fUserDefinedFunctionObjectsList = new ArrayList();
        Database database = this.getDatabase();
        if (database != null) {
            List schemaList = DatabaseHelper.getSchemaList(database);
            Iterator schemaListIter = schemaList.iterator();
            while (schemaListIter.hasNext()) {
                schema = (Schema)schemaListIter.next();
                if (this.getIsSystemSchema(schema)) continue;
                this.fUserDefinedFunctionObjectsList.addAll(schema.getUDFs());
            }
        }
        Iterator udfListIter = this.fUserDefinedFunctionObjectsList.iterator();
        while (udfListIter.hasNext()) {
            UserDefinedFunction udf = (UserDefinedFunction)udfListIter.next();
            schema = udf.getSchema();
            String qualUDFName = String.valueOf(schema.getName()) + "." + udf.getName();
            this.fUserDefinedFunctionNamesList.add(qualUDFName);
        }
    }
}

