/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant;

import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.constant.ConstantExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class NumericConstantBuilderPage
extends WizardPage
implements SelectionListener {
    protected SQLQueryObject sqlStatement;
    private Composite mainPanel;
    QueryValueExpression inputSQLExpression;
    QueryValueExpression updatedSQLExpression;
    private boolean sign;
    public static final String allowableChars = "1234567890.xXCc";
    private Button clearButton;

    public NumericConstantBuilderPage(SQLQueryObject sqlStatementArg, QueryValueExpression sqlExpr) {
        super(Messages._UI_WIZARD_NUMERIC_CONSTANT_TITLE);
        this.setTitle(Messages._UI_WIZARD_NUMERIC_CONSTANT_HEADER);
        this.setDescription(Messages._UI_WIZARD_NUMERIC_CONSTANT_EXPL);
        this.setPageComplete(true);
        this.sqlStatement = sqlStatementArg;
        this.inputSQLExpression = sqlExpr;
    }

    public void createControl(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)this.mainPanel, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqle0700");
        GridLayout mainPanelLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainPanelLayout);
        this.mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Composite topPanel = new Composite(this.mainPanel, 0);
        GridLayout topPanelLayout = new GridLayout();
        topPanelLayout.numColumns = 2;
        topPanelLayout.marginWidth = 0;
        topPanelLayout.marginHeight = 0;
        topPanelLayout.horizontalSpacing = 0;
        topPanelLayout.makeColumnsEqualWidth = false;
        topPanel.setLayout((Layout)topPanelLayout);
        topPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.sign = true;
        Composite functionButtonPanel = new Composite(this.mainPanel, 0);
        GridLayout functionButtonPanelLayout = new GridLayout();
        functionButtonPanelLayout.numColumns = 4;
        functionButtonPanelLayout.makeColumnsEqualWidth = true;
        functionButtonPanel.setLayout((Layout)functionButtonPanelLayout);
        functionButtonPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.clearButton = new Button(functionButtonPanel, 8);
        this.clearButton.setText(Messages._UI_BUTTON_CLEAR);
        this.clearButton.setLayoutData((Object)ViewUtility.createFill());
        this.clearButton.addSelectionListener((SelectionListener)this);
        this.updateFinishButton();
        this.setControl((Control)this.mainPanel);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.clearButton) {
            this.doClear();
        }
    }

    public void setInputExpression(QueryValueExpression in) {
        this.inputSQLExpression = in;
    }

    public QueryValueExpression getSQLExpression() {
        return this.updatedSQLExpression;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateFinishButton();
            if (this.inputSQLExpression != null) {
                String input = this.inputSQLExpression.getSQL();
                this.sign = !input.startsWith("-");
            }
        }
    }

    private void updateFinishButton() {
        boolean isComplete = true;
        this.setPageComplete(isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(true);
        } else if (this.getWizard() instanceof ConstantExpressionWizard) {
            ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
            wiz.setConstantOptionsPageComplete(true);
        }
    }

    public boolean performOk() {
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        } else if (this.getWizard() instanceof ConstantExpressionWizard) {
            ConstantExpressionWizard wiz = (ConstantExpressionWizard)this.getWizard();
            wiz.setSQLExpression(this.updatedSQLExpression);
        }
        return true;
    }

    private void doClear() {
        this.sign = true;
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }
}

