/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.util;

public class SQLUtil {
    public static final int NO_QUOTES = 0;
    public static final int MATCHING_SINGLE_QUOTES = 1;
    public static final int MATCHING_DOUBLE_QUOTES = 2;
    public static final int NO_MATCHING_QUOTES = 3;
    private static final char[] HexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int findQuotes(String content) {
        if (content == null) {
            return 0;
        }
        if (content.indexOf(39) < 0 && content.indexOf(34) < 0) {
            return 0;
        }
        if (content.indexOf("'") == 0 && content.lastIndexOf("'") == content.length() - 1) {
            return 1;
        }
        if (content.indexOf("\"") == 0 && content.lastIndexOf("\"") == content.length() - 1) {
            return 2;
        }
        return 3;
    }

    public static String quote(String in, char quoteChar) {
        StringBuffer buffer = new StringBuffer(in.length() + 8);
        buffer.append(quoteChar);
        int len = in.length();
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            if (c == quoteChar) {
                buffer.append(c);
            }
            buffer.append(c);
        }
        buffer.append(quoteChar);
        return buffer.toString();
    }

    public static String unquote(String quoted) {
        String content = quoted;
        if (quoted.indexOf("'") == 0 && quoted.lastIndexOf("'") == quoted.length() - 1) {
            content = quoted.substring(1, quoted.length() - 1).replaceAll("''", "'");
        } else if (quoted.indexOf("\"") == 0 && quoted.lastIndexOf("\"") == quoted.length() - 1) {
            content = quoted.substring(1, quoted.length() - 1).replaceAll("\"\"", "\"");
        }
        return content;
    }

    public static String describeSQL(String sql, int length) {
        sql = sql.trim().replaceAll(System.getProperty("line.separator"), " ");
        if ((sql = sql.replaceAll("\t", " ")).length() <= length) {
            return sql;
        }
        return sql.substring(0, length - 3).concat("...");
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        sb.append("0x");
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HexChars[bytes[i] >> 4 & 0xF]);
            sb.append(HexChars[bytes[i] & 0xF]);
        }
        return new String(sb);
    }
}

