/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParamDefList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatement;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.jface.text.IDocument;

public abstract class ParsingResult {
    protected IASTStart _rootNode;
    protected ArrayList _exceptions;

    public ParsingResult(Node rootNode, ArrayList exceptions) {
        this._rootNode = (IASTStart)rootNode;
        this._exceptions = exceptions;
    }

    public ArrayList getExceptions() {
        return this._exceptions;
    }

    public IASTStart getRootNode() {
        return this._rootNode;
    }

    public ArrayList getCursorNames(IDocument document, int offset) {
        ArrayList cursors = new ArrayList();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null) {
            cursors = this.findCursorNames(document, offset, context);
        }
        return cursors;
    }

    public HashMap getVariables(IDocument document, int offset) {
        HashMap map = new HashMap();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null) {
            map = this.findVariables(document, offset, context);
        }
        return map;
    }

    public HashMap getParameters(IDocument document, int offset) {
        HashMap map = new HashMap();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null && context instanceof IASTDeployable) {
            map = this.findParameters(document, offset, (IASTDeployable)((Object)context));
        }
        return map;
    }

    public Node findParentCompound(IDocument document, int offset, Node rootNode) {
        SimpleNode node = (SimpleNode)ParsingResult.findNode(document, offset, rootNode, true);
        if (node == null) {
            return null;
        }
        while (!(node instanceof IASTStart || node instanceof IASTDeployable || node instanceof IASTSQLStatement && "BEGIN".equalsIgnoreCase(node.getFirstToken().image))) {
            node = (SimpleNode)node.jjtGetParent();
        }
        return node;
    }

    public static Node findNode(IDocument document, int offset, Node rootNode, boolean inclusive) {
        if (!ParsingResult.contains(document, offset, rootNode, inclusive)) {
            return null;
        }
        SimpleNode root = (SimpleNode)rootNode;
        for (int i = root.jjtGetNumChildren() - 1; i >= 0; --i) {
            SimpleNode node = (SimpleNode)root.jjtGetChild(i);
            if (!ParsingResult.contains(document, offset, node, inclusive)) continue;
            return ParsingResult.findNode(document, offset, node, inclusive);
        }
        return root;
    }

    private static boolean contains(IDocument document, int offset, Node node, boolean inclusive) {
        boolean in;
        SimpleNode simpleNode = (SimpleNode)node;
        if (offset > document.getLength()) {
            return false;
        }
        boolean bl = in = simpleNode.getStartOffset(document) < offset;
        in = inclusive ? in && simpleNode.getGreatestEndOffset(document) >= offset : in && simpleNode.getEndOffset(document) >= offset;
        return in;
    }

    public Node findContainingDeployable(IDocument document, int offset, IASTStart start) {
        SimpleNode root = (SimpleNode)((Object)start);
        if (root.jjtGetNumChildren() <= 0 || root.getStartOffset(document) >= offset) {
            return null;
        }
        IASTDeployable deployable = null;
        for (int i = root.jjtGetNumChildren() - 1; i >= 0; --i) {
            SimpleNode node = (SimpleNode)root.jjtGetChild(i);
            if (root.jjtGetChild(i) instanceof IASTDeployable) {
                if (node.getStartOffset(document) >= offset) continue;
                deployable = (IASTDeployable)((Object)node);
                break;
            }
            if (node.getStartOffset(document) <= offset) break;
        }
        if (deployable == null) {
            if (!(root.jjtGetChild(0) instanceof IASTDeployable)) {
                return root;
            }
        } else {
            return deployable;
        }
        return null;
    }

    protected abstract ArrayList findCursorNames(IDocument var1, int var2, SimpleNode var3);

    protected abstract HashMap findVariables(IDocument var1, int var2, SimpleNode var3);

    protected HashMap findParameters(IDocument document, int offset, IASTDeployable node) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        if (node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                if (!(child instanceof IASTSQLParamDefList)) continue;
                for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                    Node param = child.jjtGetChild(j);
                    if (!(param instanceof IASTSQLParam)) continue;
                    map.put(((IASTSQLParam)((Object)param)).getName(), param);
                }
                break;
            }
        }
        return map;
    }

    protected abstract HashMap findCursors(IDocument var1, int var2, SimpleNode var3);

    public HashMap getCursors(IDocument document, int offset) {
        HashMap map = new HashMap();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null && context instanceof IASTDeployable) {
            map = this.findCursors(document, offset, context);
        }
        return map;
    }

    public abstract boolean isValidObjectsFormats(ArrayList var1);

    public abstract boolean isVarOrPara(ArrayList var1);

    public abstract ArrayList getPrefix(ArrayList var1, Node var2);

    public abstract ArrayList getUnSharableTempTables(IDocument var1, int var2);
}

