/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class RoutineAnnotationModel
extends ResourceMarkerAnnotationModel {
    protected ProcIdentifier _procIdentifier;
    protected IWorkspace _workspace = ResourcesPlugin.getWorkspace();
    public static final String ATTR_PROCIDENTIFIER = RoutineEditorActivator.PLUGIN_ID + ".procIdentifier";

    public RoutineAnnotationModel(ProcIdentifier procid) {
        super((IResource)ResourcesPlugin.getWorkspace().getRoot());
        this._procIdentifier = procid;
    }

    protected boolean isAcceptable(IMarker marker) {
        boolean acceptable = super.isAcceptable(marker);
        if (acceptable) {
            try {
                String type = marker.getType();
                if ("org.eclipse.datatools.sqltools.sqleditor.syntaxproblem".equals(type) || "org.eclipse.datatools.sqltools.sqleditor.portabilitytask".equals(type)) {
                    String id;
                    String str = marker.getAttribute("SQL_SOURCE_ID", "");
                    return str.indexOf(id = "(" + this._procIdentifier.encode() + ")") >= 0;
                }
            }
            catch (CoreException ex) {
                RoutineEditorActivator.getDefault().log(ex);
            }
        }
        return false;
    }

    protected boolean isAffected(IMarkerDelta markerDelta) {
        return this.isAcceptable(markerDelta.getMarker());
    }
}

