/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IItemWithCode;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RoutineAction;
import org.eclipse.datatools.sqltools.routineeditor.util.RoutineUtil;
import org.eclipse.datatools.sqltools.sql.util.DSEUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IActionDelegate;

public class DropRoutineAction
extends RoutineAction
implements IActionDelegate {
    public DropRoutineAction() {
        this.init();
    }

    public DropRoutineAction(Object selectedResource) {
        this.init();
        this.initSQLObject((IAction)this, selectedResource);
        this.initConnectionProfile();
    }

    protected void init() {
        this.setText(Messages.DropRoutineAction_label);
        this.setToolTipText(Messages.DropRoutineAction_tooltip);
        this.setImageDescriptor(RoutineEditorImages.getImageDescriptor("drop"));
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this._sqlObject != null && this._connectionProfile != null) {
            boolean ok = MessageDialog.openConfirm(null, (String)Messages.DropRoutineAction_label, (String)NLS.bind((String)Messages.DropRoutineAction_message, (Object)this._sqlObject.getName()));
            if (!ok) {
                return;
            }
            DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(this._connectionProfile.getName(), this.getDatabaseName());
            ProcIdentifier proc = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)databaseIdentifier, (SQLObject)this._sqlObject);
            try {
                IControlConnection controlConnection = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
                IItemWithCode item = (IItemWithCode)controlConnection.getDBItem(proc);
                item.drop();
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
            }
            RoutineUtil.closeEditor(proc);
            DSEUtil.refreshParent((SQLObject)this._sqlObject);
            DropRoutineAction.deleteLaunchConfigration(proc);
        }
    }

    private static void deleteLaunchConfigration(ProcIdentifier proc) {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidates = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            candidates = new ArrayList<ILaunchConfiguration>(configs.length);
            for (int i = 0; i < configs.length; ++i) {
                ProcIdentifier lConfigProc;
                if (LaunchHelper.isAdHocSQL(configs[i]) || (lConfigProc = LaunchHelper.readProcIdentifier(configs[i])) == null) continue;
                String name1 = proc.getProcName();
                String name2 = lConfigProc.getProcName();
                String ownerName1 = proc.getOwnerName();
                String ownerName2 = lConfigProc.getOwnerName();
                int type1 = proc.getType();
                int type2 = lConfigProc.getType();
                String dbName1 = proc.getDatabaseName();
                String dbName2 = lConfigProc.getDatabaseName();
                if (name1 == null || name2 == null || ownerName1 == null || ownerName2 == null) {
                    RoutineEditorActivator.getDefault().log(NLS.bind((String)Messages.dmpActionHandler_deleteLaunchConfigration_NameOrOwnerNull, (Object[])new String[]{name1, name2, ownerName1, ownerName2}));
                    continue;
                }
                if (!name1.equals(name2) || !ownerName1.equals(ownerName2) || type1 != type2 || !dbName1.equals(dbName2)) continue;
                candidates.add(configs[i]);
            }
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                ILaunchConfiguration lc = (ILaunchConfiguration)iter.next();
                lc.delete();
            }
        }
        catch (CoreException ex) {
            RoutineEditorActivator.getDefault().log(ex);
        }
    }
}

