/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditor;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RoutineAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.SPLaunchShortcut;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends RoutineAction
implements IActionDelegate {
    private RoutineEditor _sqlEditor;

    public RunAction() {
        this(null);
    }

    public RunAction(RoutineEditor targetEditor) {
        this.setText(Messages.RunAction_label);
        this.setToolTipText(Messages.RunAction_tooltip);
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.runAction");
        this.setActiveEditor(targetEditor);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.run_action");
    }

    public void setActiveEditor(RoutineEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    public void run() {
        this.run(null);
    }

    public void update() {
        this.setEnabled(this._sqlEditor != null || this._routine != null);
    }

    public void run(IAction action) {
        ProcIdentifier proc = null;
        if (this._sqlEditor == null || this._sqlEditor.getEditorInput() == null) {
            try {
                proc = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)new DatabaseIdentifier(this._connectionProfile.getName(), this._database.getName()), (SQLObject)this._routine);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)new ProcEditorInput(proc), RoutineEditor.EDITOR_ID);
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
            }
        } else {
            ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            proc = procEditorInput.getProcIdentifier();
        }
        if (proc != null) {
            try {
                SPLaunchShortcut.launch(proc, "run");
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
            }
        }
    }
}

