/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.SQLRoutineDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.internal.Messages;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.ui.IEditorInput;

public class RoutineEditorDocumentProviderFactory {
    private static IRoutineEditorDocumentProvider debuggerDocumentProvider = null;

    public static IRoutineEditorDocumentProvider getDocumentProvider(IEditorInput input) {
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        boolean supportsDebugging = false;
        if (input instanceof ProcEditorInput) {
            ProcIdentifier procIdentifier = ((ProcEditorInput)input).getProcIdentifier();
            IControlConnection con = null;
            try {
                con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(procIdentifier.getDatabaseIdentifier());
                supportsDebugging = con.supportsDebugging();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!supportsDebugging) {
            return new SQLRoutineDocumentProvider();
        }
        if (debuggerDocumentProvider != null) {
            return debuggerDocumentProvider;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(RoutineEditorActivator.PLUGIN_ID, "documentprovider");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0 && (configElements = extensions[0].getConfigurationElements())[0].getName().equals("debuggerDocumentProvider")) {
            String className = configElements[0].getAttribute("class");
            try {
                debuggerDocumentProvider = (IRoutineEditorDocumentProvider)configElements[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                RoutineEditorActivator.getDefault().log(Messages.getString("SQLEditorDocumentProvider.error.readprovider", className), e);
            }
        }
        if (debuggerDocumentProvider == null) {
            debuggerDocumentProvider = new SQLRoutineDocumentProvider();
        }
        return debuggerDocumentProvider;
    }
}

