/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;

public class ProcEditorInput
extends SQLEditorStorageEditorInput {
    ProcIdentifier _procIdentifier;
    boolean _isEditable = true;

    public ProcEditorInput(ProcIdentifier procid) {
        super(procid.getDisplayString(), "");
        this._procIdentifier = procid;
        String code = "";
        try {
            IControlConnection controlConnection = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(procid.getDatabaseIdentifier());
            code = controlConnection.getProcSource(procid);
        }
        catch (Exception e) {
            RoutineEditorActivator.getDefault().log(e);
        }
        this.setStorage((IStorage)new SQLEditorStorage(this._procIdentifier.getDisplayString(), code));
        this.setConnectionInfo((ISQLEditorConnectionInfo)new SQLEditorConnectionInfo(ProfileUtil.getDatabaseVendorDefinitionId((String)procid.getProfileName()), procid.getProfileName(), procid.getDatabaseName(), procid.getOwnerName()));
    }

    public ProcIdentifier getProcIdentifier() {
        return this._procIdentifier;
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    public void setEditable(boolean isEditable) {
        this._isEditable = isEditable;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this._procIdentifier.getDisplayString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this._procIdentifier.getLongDisplayString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ProcIdentifier.class) {
            return this._procIdentifier;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcEditorInput) {
            ProcEditorInput input = (ProcEditorInput)((Object)obj);
            return this._procIdentifier.equals(input._procIdentifier);
        }
        return false;
    }

    public String getSourceCode() {
        return ((SQLEditorStorage)this.getStorage()).getContentsString();
    }

    public void setSourceCode(String code) {
        this.setStorage((IStorage)new SQLEditorStorage(this._procIdentifier.getDisplayString(), code));
    }
}

