/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowModeSection;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.TextResultViewer;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.PreferenceUtil;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SingleWindowTextSection
extends SingleWindowModeSection {
    public static String _LINESEPARATOR = System.getProperty("line.separator");
    private TextResultViewer _textViewer;
    private boolean _isLastSubResultAppended = true;

    public SingleWindowTextSection(Composite composite, ResultsViewControl resultsViewControl) {
        super(composite, resultsViewControl);
    }

    public SingleWindowTextSection(Composite composite, IResultInstance instance, ResultsViewControl resultsViewControl) {
        super(composite, instance, resultsViewControl);
    }

    protected void createViewerForResultInstance(IResultInstance instance) {
        this._textViewer.getViewer().getTextWidget().dispose();
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this._resultInstance != null) {
            SaveAllResultSetsAction saveAll = new SaveAllResultSetsAction(this._composite.getShell(), this._resultInstance);
            saveAll.setText(Messages.SaveAllResultSetAction_Title);
            actions.add((Object)saveAll);
            ExportAllResultSetsAction exportAll = new ExportAllResultSetsAction(this._composite.getShell(), this._resultInstance);
            exportAll.setText(Messages.ExportAllResultSetAction_Title);
            actions.add((Object)exportAll);
            actions.add(new Separator());
            PrintResultSetAction printAll = new PrintResultSetAction(this._resultInstance, this._composite);
            printAll.setText(Messages.PrintAllResultSetAction_Title);
            actions.add((Object)printAll);
        }
        this._textViewer = new TextResultViewer(this._composite, 770, actions);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        this._textViewer.getViewer().getTextWidget().setEditable(true);
        this._textViewer.getViewer().getTextWidget().setEnabled(true);
        this._textViewer.getViewer().setDocument(this.createDocumentForResultInstance(instance));
        this.onInstanceFinished();
        this._composite.layout(true);
    }

    private IDocument createDocumentForResultInstance(IResultInstance instance) {
        int i = 0;
        while (i < instance.getItemCount()) {
            IResultSetObject result;
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 3 && !(result = (IResultSetObject)item.getResultObject()).isAllResultLoaded()) {
                this._isResultHid = true;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer("");
        if (instance.getSubResults().size() > 0) {
            Iterator it = instance.getSubResults().iterator();
            while (it.hasNext()) {
                IResultInstance subInstance = (IResultInstance)it.next();
                if (subInstance == null) continue;
                sb.append(this.getSubResultInstanceText(subInstance));
            }
        } else {
            int i2 = 0;
            while (i2 < instance.getItemCount()) {
                ResultItem item = instance.getItem(i2);
                sb.append(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg));
                ++i2;
            }
        }
        Document document = new Document();
        document.set(sb.toString());
        return document;
    }

    private String getSubResultInstanceText(IResultInstance instance) {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.addLinePrefix(instance.getOperationCommand().getDisplayString()));
        sb.append(ColumnAlignedResultItem.getResultInstanceDispString(instance, PreferenceUtil.getString(ResultsViewPlugin.getDefault().getPreferenceStore(), "org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr", this._resultsViewControl.getUsePreferences())));
        return sb.toString();
    }

    private String addLinePrefix(String sql) {
        StringBuffer sb = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(sql, _LINESEPARATOR);
        int lineNumber = 1;
        while (st.hasMoreTokens()) {
            sb.append(String.valueOf(lineNumber++) + "> ");
            sb.append(st.nextToken()).append(_LINESEPARATOR);
        }
        sb.append(String.valueOf(lineNumber) + "> go").append(_LINESEPARATOR);
        return sb.toString();
    }

    public void onNewItemAppended(ResultItem item, int index) {
        IResultSetObject result;
        if (this._resultInstance == null || this._displayedItems.contains(item)) {
            return;
        }
        this._displayedItems.add(item);
        if (item.getResultType() == 3 && !(result = (IResultSetObject)item.getResultObject()).isAllResultLoaded()) {
            this._isResultHid = true;
        }
        StringBuffer sb = new StringBuffer("");
        if (this._resultInstance.isMayHaveSubResults()) {
            IResultInstance preSubInstance;
            if (index > 0 && (preSubInstance = (IResultInstance)this._resultInstance.getSubResults().get(index - 1)) != null) {
                sb.append(ColumnAlignedResultItem.getResultInstanceDispString(preSubInstance, PreferenceUtil.getString(ResultsViewPlugin.getDefault().getPreferenceStore(), "org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr", this._resultsViewControl.getUsePreferences())));
            }
            sb.append(this.addLinePrefix(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg)));
            this._isLastSubResultAppended = false;
        } else {
            sb.append(ColumnAlignedResultItem.getResultItemDisplayString(item, this._nullValue, this._showHeadings, this._showRowCountMsg));
        }
        this._messageCache.add(sb.toString());
        super.onNewItemAppended(item, index);
    }

    protected void outputToViewer(List outputList) {
        StringBuffer sb = new StringBuffer();
        sb.append(this._textViewer.getViewer().getTextWidget().getText());
        Iterator iterator = outputList.iterator();
        while (iterator.hasNext()) {
            String message = (String)iterator.next();
            sb.append(message);
        }
        this._textViewer.getViewer().getTextWidget().setVisible(false);
        this._textViewer.getViewer().getTextWidget().setText(sb.toString());
        this._textViewer.getViewer().getTextWidget().invokeAction(17039368);
        this._textViewer.getViewer().getTextWidget().setVisible(true);
        this._textViewer.resetUndoMgr();
    }

    public void createInitialControl(Composite composite) {
        super.createInitialControl(composite);
        this._textViewer = new TextResultViewer(this._composite, 770, null);
        GridData gd = new GridData(1808);
        this._textViewer.getViewer().getTextWidget().setLayoutData((Object)gd);
        this._textViewer.getViewer().setDocument((IDocument)new Document(""));
        this._textViewer.getViewer().getTextWidget().setEditable(false);
        this._textViewer.getViewer().getTextWidget().setEnabled(false);
    }

    public void onInstanceFinished() {
        super.onInstanceFinished();
        if (this._resultInstance.getSubResults().size() > 0 && !this._isLastSubResultAppended) {
            StringBuffer sb = new StringBuffer("");
            sb.append(this._textViewer.getViewer().getTextWidget().getText());
            int indexOfLastSubResult = this._resultInstance.getSubResults().size() - 1;
            IResultInstance lastSubInstance = (IResultInstance)this._resultInstance.getSubResults().get(indexOfLastSubResult);
            if (lastSubInstance != null) {
                sb.append(ColumnAlignedResultItem.getResultInstanceDispString(lastSubInstance, PreferenceUtil.getString(ResultsViewPlugin.getDefault().getPreferenceStore(), "org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr", this._resultsViewControl.getUsePreferences())));
            }
            this._textViewer.getViewer().getTextWidget().setVisible(false);
            this._textViewer.getViewer().getTextWidget().setText(sb.toString());
            this._textViewer.getViewer().getTextWidget().invokeAction(17039368);
            this._textViewer.getViewer().getTextWidget().setVisible(true);
            this._textViewer.resetUndoMgr();
            this._isLastSubResultAppended = true;
        }
        if (this._resultInstance.getParameters() == null) {
            return;
        }
    }

    public void onInstanceReseted() {
        this._textViewer.getViewer().getTextWidget().setText("");
    }

    public TextResultViewer getTextViewer() {
        return this._textViewer;
    }
}

