/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class Images {
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    private static final String NAME_PREFIX = "org.eclipse.datatools.sqltools.result";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.datatools.sqltools.result".length();
    private static URL _baseURL = null;
    private static ImageRegistry fgImageRegistry = null;
    private static HashMap fgAvoidSWTErrorMap = new HashMap();
    public static final String IMG_REMOVEALL = "org.eclipse.datatools.sqltools.resultremoveall.gif";
    public static final ImageDescriptor DESC_REMOVEALL;
    public static final String IMG_REMOVEALL_DISABLE = "org.eclipse.datatools.sqltools.resultremoveall_disable.gif";
    public static final ImageDescriptor DESC_REMOVEALL_DISABLE;
    public static final String IMG_REMOVE = "org.eclipse.datatools.sqltools.resultremove.gif";
    public static final ImageDescriptor DESC_REMOVE;
    public static final String IMG_REMOVE_DISABLE = "org.eclipse.datatools.sqltools.resultremove_disable.gif";
    public static final ImageDescriptor DESC_REMOVE_DISABLE;
    public static final String IMG_SUCCESS = "org.eclipse.datatools.sqltools.resultsuccess.gif";
    public static final ImageDescriptor DESC_SUCCESS;
    public static final String IMG_WARNING = "org.eclipse.datatools.sqltools.resultwarning.gif";
    public static final ImageDescriptor DESC_WARNING;
    public static final String IMG_FAIL = "org.eclipse.datatools.sqltools.resultfail.gif";
    public static final ImageDescriptor DESC_FAIL;
    public static final String IMG_CRITICAL = "org.eclipse.datatools.sqltools.resultcritical.gif";
    public static final ImageDescriptor DESC_CRITICAL;
    public static final String IMG_TERMINATE = "org.eclipse.datatools.sqltools.resultterminate.gif";
    public static final ImageDescriptor DESC_TERMINATE;
    public static final String IMG_TERMINATE_DISABLE = "org.eclipse.datatools.sqltools.resultterminate_disable.gif";
    public static final ImageDescriptor DESC_TERMINATE_DISABLE;
    public static final String IMG_RUNNING = "org.eclipse.datatools.sqltools.resultrunning.gif";
    public static final ImageDescriptor DESC_RUNNING;
    public static final String IMG_STARTED = "org.eclipse.datatools.sqltools.resultstarted.gif";
    public static final ImageDescriptor DESC_STARTED;
    public static final String IMG_RESULT_VIEW_WARN = "org.eclipse.datatools.sqltools.resultwarning_st_obj.gif";
    public static final ImageDescriptor DESC_RESULT_VIEW_WARN;
    public static final String IMG_HORIZONTAL_RESULTS_VIEW = "org.eclipse.datatools.sqltools.resulthorizontal_results_view.gif";
    public static final ImageDescriptor DESC_HORIZONTAL_RESULTS_VIEW;
    public static final String IMG_VERTICAL_RESULTS_VIEW = "org.eclipse.datatools.sqltools.resultvertical_results_view.gif";
    public static final ImageDescriptor DESC_VERTICAL_RESULTS_VIEW;
    public static final String IMG_EXPORT_RESULT = "org.eclipse.datatools.sqltools.resultexport_result.gif";
    public static final ImageDescriptor DESC_EXPORT_RESULT;
    public static final String IMG_RESULT_VIEW_FILTER = "org.eclipse.datatools.sqltools.resultresult_view_filter.gif";
    public static final ImageDescriptor DESC_RESULT_VIEW_FILTER;
    public static final String IMG_SINGLE_TAB = "org.eclipse.datatools.sqltools.resultsingle_tab.gif";
    public static final ImageDescriptor DESC_SINGLE_TAB;
    public static final String IMG_TEXT_MODE = "org.eclipse.datatools.sqltools.resulttext_mode.gif";
    public static final ImageDescriptor DESC_TEXT_MODE;

    static {
        String pathSuffix = "icons/";
        _baseURL = ResultsViewPlugin.getDefault().getBundle().getEntry(pathSuffix);
        DESC_REMOVEALL = Images.createManaged(IMG_REMOVEALL);
        DESC_REMOVEALL_DISABLE = Images.createManaged(IMG_REMOVEALL_DISABLE);
        DESC_REMOVE = Images.createManaged(IMG_REMOVE);
        DESC_REMOVE_DISABLE = Images.createManaged(IMG_REMOVE_DISABLE);
        DESC_SUCCESS = Images.createManaged(IMG_SUCCESS);
        DESC_WARNING = Images.createManaged(IMG_WARNING);
        DESC_FAIL = Images.createManaged(IMG_FAIL);
        DESC_CRITICAL = Images.createManaged(IMG_CRITICAL);
        DESC_TERMINATE = Images.createManaged(IMG_TERMINATE);
        DESC_TERMINATE_DISABLE = Images.createManaged(IMG_TERMINATE_DISABLE);
        DESC_RUNNING = Images.createManaged(IMG_RUNNING);
        DESC_STARTED = Images.createManaged(IMG_STARTED);
        DESC_RESULT_VIEW_WARN = Images.createManaged(IMG_RESULT_VIEW_WARN);
        DESC_HORIZONTAL_RESULTS_VIEW = Images.createManaged(IMG_HORIZONTAL_RESULTS_VIEW);
        DESC_VERTICAL_RESULTS_VIEW = Images.createManaged(IMG_VERTICAL_RESULTS_VIEW);
        DESC_EXPORT_RESULT = Images.createManaged(IMG_EXPORT_RESULT);
        DESC_RESULT_VIEW_FILTER = Images.createManaged(IMG_RESULT_VIEW_FILTER);
        DESC_SINGLE_TAB = Images.createManaged(IMG_SINGLE_TAB);
        DESC_TEXT_MODE = Images.createManaged(IMG_TEXT_MODE);
    }

    public static Image get(String key) {
        return Images.getImageRegistry().get(key);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            Iterator iter = fgAvoidSWTErrorMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static ImageDescriptor createManaged(String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)Images.makeIconFileURL(name.substring(NAME_PREFIX_LENGTH)));
            fgAvoidSWTErrorMap.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            _log.error("Debugger_Images_malformedURLException", (Object)name, (Throwable)e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String name) throws MalformedURLException {
        if (_baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(name);
        return new URL(_baseURL, buffer.toString());
    }
}

