/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.preference;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSetViewerDescriptor;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSetViewerRegistryReader;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ResultSetViewerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo viewersCombo;
    private String[] myViewers;
    private String viewerName;
    public static final String DEFAULT_VIEWER = Messages.ResultSetViewerPage_defaultViewer;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ResultsViewPlugin.getDefault().getPreferenceStore());
        this.populateViewerNames();
    }

    public static String getViewerNameFromExtension() {
        List viewerDescriptors = ResultSetViewerRegistryReader.getInstance().getResultSetViewers();
        String viewerName = DEFAULT_VIEWER;
        if (viewerDescriptors.size() == 1 && (viewerName = ((ResultSetViewerDescriptor)viewerDescriptors.get(0)).getDefaultViewer()) == null) {
            viewerName = DEFAULT_VIEWER;
        }
        return viewerName;
    }

    private void populateViewerNames() {
        List viewerDescriptors = ResultSetViewerRegistryReader.getInstance().getResultSetViewers();
        int viewerCount = viewerDescriptors.size();
        this.myViewers = new String[viewerCount + 1];
        this.myViewers[0] = DEFAULT_VIEWER;
        Iterator iter = viewerDescriptors.iterator();
        int count = 0;
        while (iter.hasNext()) {
            ResultSetViewerDescriptor desc = (ResultSetViewerDescriptor)iter.next();
            this.myViewers[++count] = desc.getViewerID();
        }
    }

    public void setViewerName(String name) {
        this.viewerName = name;
    }

    public String getViewerName() {
        return this.viewerName;
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = this.getPreferenceStore();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Group viewersGroup = new Group(comp, 0);
        viewersGroup.setText(Messages.ResultSetViewerPage_group);
        viewersGroup.setLayoutData((Object)new GridData(768));
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        viewersGroup.setLayout((Layout)gLayout);
        Label label = new Label((Composite)viewersGroup, 0);
        label.setText(Messages.ResultSetViewerPage_select_viewer);
        this.viewersCombo = new Combo((Composite)viewersGroup, 12);
        this.viewersCombo.setToolTipText(Messages.ResultSetViewerPage_viewer_tooltip);
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        this.viewersCombo.setLayoutData((Object)comboData);
        int i = 0;
        while (i < this.myViewers.length) {
            this.viewersCombo.add(this.myViewers[i]);
            ++i;
        }
        this.viewersCombo.setText(store.getString("org.eclipse.datatools.sqltools.result.preferences.resultsetviewer.viewername"));
        this.viewersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ResultSetViewerPreferencePage.this.viewerName = ResultSetViewerPreferencePage.this.viewersCombo.getText();
            }
        });
        return comp;
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.resultsetviewer.viewername", this.viewersCombo.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        this.viewersCombo.setText(ResultSetViewerPreferencePage.getViewerNameFromExtension());
        super.performDefaults();
    }
}

