/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.ByteArrayInputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ResultsViewAPI {
    private static ResultsViewAPI _instance;
    private static ILogger _log;
    private boolean _checkSRV = true;
    private IWorkbenchPage _activePage;
    private IResultManager _manager = ResultsViewPlugin.getResultManager();

    static {
        _log = ResultsViewPlugin.getLogger(null);
    }

    public static synchronized ResultsViewAPI getInstance() {
        if (_instance == null) {
            _instance = new ResultsViewAPI();
        }
        return _instance;
    }

    private ResultsViewAPI() {
    }

    public int getCurrentStatus(OperationCommand cmd) {
        if (cmd == null) {
            return -1;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            return instance.getStatus();
        }
        return -1;
    }

    public Throwable[] getFailThrowables(OperationCommand cmd, boolean includeSubThrowables) {
        if (cmd == null) {
            return null;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            Throwable[] parentErrors = instance.getFailThrowables();
            int i = 0;
            while (i < parentErrors.length) {
                if (parentErrors[i] != null) {
                    errors.add(parentErrors[i]);
                }
                ++i;
            }
            if (!includeSubThrowables) {
                return errors.toArray(new Throwable[errors.size()]);
            }
            Iterator iter = instance.getSubResults().iterator();
            while (iter.hasNext()) {
                IResultInstance subIns = (IResultInstance)iter.next();
                OperationCommand subCmd = subIns.getOperationCommand();
                Throwable[] subErrors = this.getFailThrowables(subCmd, true);
                if (subErrors == null) continue;
                int i2 = 0;
                while (i2 < subErrors.length) {
                    if (subErrors[i2] != null) {
                        errors.add(subErrors[i2]);
                    }
                    ++i2;
                }
            }
            return errors.toArray(new Throwable[errors.size()]);
        }
        return null;
    }

    public Throwable[] getFailThrowables(OperationCommand cmd) {
        return this.getFailThrowables(cmd, false);
    }

    public boolean appendThrowable(OperationCommand cmd, Throwable th) {
        if (cmd == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.moreThrowable(th);
            return true;
        }
        return false;
    }

    public boolean appendPlainMessage(OperationCommand cmd, String message) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || message == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.morePlainMessage(message);
            return true;
        }
        return false;
    }

    public boolean appendResultSet(OperationCommand cmd, IResultSetObject rs) {
        block5: {
            IResultInstance instance;
            block6: {
                if (!this.checkView()) {
                    return false;
                }
                if (cmd == null || rs == null) {
                    return false;
                }
                instance = this._manager.getInstance(cmd);
                try {
                    if (instance == null) break block5;
                    if (!instance.isFinished()) break block6;
                    return false;
                }
                catch (Exception e) {
                    _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
                    return false;
                }
            }
            instance.moreResultSet(rs);
            return true;
        }
        return false;
    }

    public boolean appendResultSet(OperationCommand cmd, ResultSet rs) {
        block5: {
            IResultInstance instance;
            block6: {
                if (!this.checkView()) {
                    return false;
                }
                if (cmd == null || rs == null) {
                    return false;
                }
                instance = this._manager.getInstance(cmd);
                try {
                    if (instance == null) break block5;
                    if (!instance.isFinished()) break block6;
                    return false;
                }
                catch (Exception e) {
                    _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
                    return false;
                }
            }
            instance.moreResultSet(rs);
            return true;
        }
        return false;
    }

    public boolean appendStatusMessage(OperationCommand cmd, String message) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || message == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.moreStatusMessage(message);
            return true;
        }
        return false;
    }

    public boolean appendUpdateCountMessage(OperationCommand cmd, int count) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || count < 0) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.moreUpdateCount(count);
            return true;
        }
        return false;
    }

    public boolean appendXMLResultSet(OperationCommand cmd, String xmlString) {
        block7: {
            XMLResultSetObject rs;
            IResultInstance instance;
            block8: {
                if (!this.checkView()) {
                    return false;
                }
                if (cmd == null || xmlString == null) {
                    return false;
                }
                instance = this._manager.getInstance(cmd);
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
                }
                catch (Exception dex) {
                    _log.error("ResultsViewAPI_notwellformed_xml", (Throwable)dex);
                    return false;
                }
                try {
                    rs = new XMLResultSetObject(xmlString);
                    if (instance == null) break block7;
                    if (!instance.isFinished()) break block8;
                    return false;
                }
                catch (Exception e) {
                    _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
                    return false;
                }
            }
            instance.moreResultSet(rs);
            return true;
        }
        return false;
    }

    public boolean checkView() {
        int i;
        if (!this._checkSRV) {
            return true;
        }
        IWorkbenchWindow activeWindow = ResultsViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            IWorkbenchWindow[] windows = ResultsViewPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            i = 0;
            while (i < windows.length) {
                activeWindow = windows[0];
                if (activeWindow != null) break;
                ++i;
            }
            if (activeWindow == null) {
                return false;
            }
        }
        this._activePage = activeWindow.getActivePage();
        if (this._activePage == null) {
            IWorkbenchPage[] pages = activeWindow.getPages();
            i = 0;
            while (i < pages.length) {
                this._activePage = pages[0];
                if (this._activePage != null) break;
                ++i;
            }
            if (this._activePage == null) {
                return false;
            }
        }
        activeWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IViewPart view = ResultsViewAPI.this._activePage.findView("org.eclipse.datatools.sqltools.result.resultView");
                    if (ResultsViewAPI.this._activePage.isPartVisible((IWorkbenchPart)view)) {
                        return;
                    }
                    ResultsViewAPI.this._activePage.showView("org.eclipse.datatools.sqltools.result.resultView", null, 2);
                }
                catch (PartInitException ex) {
                    _log.error("ResultsViewAPI_checkview_error", (Throwable)ex);
                }
            }
        });
        return true;
    }

    public boolean createNewInstance(OperationCommand cmd, Runnable terminateHandler) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null) {
            return false;
        }
        if (cmd.getDisplayString() == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            return false;
        }
        instance = this._manager.createNewResultInstance(cmd, terminateHandler);
        return instance != null;
    }

    public IResultInstance getResultInstance(OperationCommand cmd) {
        return this._manager.getInstance(cmd);
    }

    public boolean showParameters(OperationCommand cmd, List params) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || params == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.showParameters(params);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(OperationCommand cmd, int status) {
        if (!this.checkView()) {
            return false;
        }
        OperationCommand operationCommand = cmd;
        synchronized (operationCommand) {
            block9: {
                IResultInstance instance;
                block11: {
                    block10: {
                        block8: {
                            if (cmd != null && status >= 1 && status <= 7) break block8;
                            return false;
                        }
                        instance = this._manager.getInstance(cmd);
                        if (instance == null) break block9;
                        if (!instance.isFinished()) break block10;
                        return false;
                    }
                    if (instance.getStatus() != 2 || status != 1) break block11;
                    return false;
                }
                instance.updateStatus(status);
                return true;
            }
            return false;
        }
    }

    public boolean createSubInstance(OperationCommand parentCmd, OperationCommand cmd, Runnable terminateHandler) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || parentCmd == null) {
            return false;
        }
        IResultInstance parentResult = this._manager.getInstance(parentCmd);
        if (parentResult != null && !parentResult.isFinished()) {
            parentResult.createSubResult(cmd, terminateHandler);
            return true;
        }
        return false;
    }

    public OperationCommand getSubOperationCommand(OperationCommand parentCmd, int subNum) {
        if (parentCmd == null) {
            return null;
        }
        IResultInstance parentResult = this._manager.getInstance(parentCmd);
        if (parentResult != null) {
            if (subNum > parentResult.getSubResults().size() - 1) {
                return null;
            }
            return ((IResultInstance)parentResult.getSubResults().get(subNum)).getOperationCommand();
        }
        return null;
    }

    public int calculateStatus(OperationCommand command) {
        if (command == null) {
            return 6;
        }
        IResultInstance result = this._manager.getInstance(command);
        if (result != null) {
            return result.calculateStatus();
        }
        return 6;
    }

    public int getMaxRowPreference() {
        return ResultsViewPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.datatools.sqltools.result.preferences.display.maxrowcount");
    }

    public int getMaxRowDisplayPreference() {
        return ResultsViewPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.datatools.sqltools.result.preferences.display.maxdisplayrowcount");
    }

    public void setCheckSRV(boolean checksrv) {
        this._checkSRV = checksrv;
    }
}

