/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.result.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.internal.export.IOutputterDescriptor;
import org.eclipse.datatools.sqltools.result.internal.export.OutputterDescriptor;

public class OutputterRegistryReader {
    private static OutputterRegistryReader _instance;
    private List _outputters;

    private OutputterRegistryReader() {
    }

    public static synchronized OutputterRegistryReader getInstance() {
        if (_instance == null) {
            _instance = new OutputterRegistryReader();
        }
        return _instance;
    }

    public synchronized List getOutputters() {
        if (this._outputters == null) {
            this._outputters = new ArrayList();
            this.init();
        }
        return this._outputters;
    }

    public List getOutputtersSupportXML() {
        ArrayList<IOutputterDescriptor> outputters = new ArrayList<IOutputterDescriptor>();
        this.getOutputters();
        Iterator iter = this._outputters.iterator();
        while (iter.hasNext()) {
            IOutputterDescriptor descriptor = (IOutputterDescriptor)iter.next();
            if (!descriptor.supportXMLResult()) continue;
            outputters.add(descriptor);
        }
        return outputters;
    }

    public AbstractOutputter getOutputter(String typeId) {
        if (typeId == null) {
            return null;
        }
        this.getOutputters();
        Iterator iter = this._outputters.iterator();
        while (iter.hasNext()) {
            IOutputterDescriptor descriptor = (IOutputterDescriptor)iter.next();
            if (!descriptor.getTypeId().equals(typeId)) continue;
            return descriptor.getOutputter();
        }
        return null;
    }

    public IOutputterDescriptor getOutputterDesciptor(boolean supportXML, int index) {
        List outputters;
        if (index < 0) {
            return null;
        }
        this.getOutputters();
        List list = outputters = supportXML ? this.getOutputtersSupportXML() : this._outputters;
        if (index >= outputters.size()) {
            return null;
        }
        return (OutputterDescriptor)outputters.get(index);
    }

    public String[] getOutputterDspStrings(boolean supportXML) {
        Iterator iter;
        ArrayList<String> outputterDspStrings = new ArrayList<String>();
        this.getOutputters();
        Iterator iterator = iter = supportXML ? this.getOutputtersSupportXML().iterator() : this._outputters.iterator();
        while (iter.hasNext()) {
            IOutputterDescriptor descriptor = (IOutputterDescriptor)iter.next();
            outputterDspStrings.add(descriptor.getDisplayString());
        }
        return outputterDspStrings.toArray(new String[outputterDspStrings.size()]);
    }

    public String[] getFilterStrings(boolean supportXML) {
        Iterator iter;
        ArrayList<String> filterStrings = new ArrayList<String>();
        this.getOutputters();
        Iterator iterator = iter = supportXML ? this.getOutputtersSupportXML().iterator() : this._outputters.iterator();
        while (iter.hasNext()) {
            IOutputterDescriptor descriptor = (IOutputterDescriptor)iter.next();
            filterStrings.add(descriptor.getExtFilterString());
        }
        return filterStrings.toArray(new String[filterStrings.size()]);
    }

    private void init() {
        ArrayList<OutputterDescriptor> outputters = new ArrayList<OutputterDescriptor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.datatools.sqltools.result", "resultSetOutputter");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                String typeId = elements[j].getAttribute("typeId");
                String typeName = elements[j].getAttribute("typeName");
                String fileExt = elements[j].getAttribute("fileExtension");
                String extensionFilter = elements[j].getAttribute("extensionFilter");
                String supportDelimiterStr = elements[j].getAttribute("supportDelimiter");
                String supportXMLResultStr = elements[j].getAttribute("supportXMLResult");
                if (typeName == null || typeName.trim().length() == 0) continue;
                boolean supportDelimiter = false;
                boolean supportXMLResult = false;
                AbstractOutputter outputter = null;
                if (supportDelimiterStr != null && supportDelimiterStr.length() > 0) {
                    try {
                        supportDelimiter = Boolean.valueOf(supportDelimiterStr);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (supportXMLResultStr != null && supportXMLResultStr.length() > 0) {
                    try {
                        supportXMLResult = Boolean.valueOf(supportXMLResultStr);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    outputter = (AbstractOutputter)elements[j].createExecutableExtension("class");
                }
                catch (Exception e) {
                    continue;
                }
                OutputterDescriptor descriptor = new OutputterDescriptor(typeId, typeName, fileExt, supportDelimiter, outputter, supportXMLResult, extensionFilter);
                outputters.add(descriptor);
            }
        }
        Iterator iter = outputters.iterator();
        ArrayList<IOutputterDescriptor> builtInOutputters = new ArrayList<IOutputterDescriptor>();
        while (iter.hasNext()) {
            IOutputterDescriptor descriptor = (IOutputterDescriptor)iter.next();
            if (descriptor.getTypeId().equals("org.eclipse.datatools.sqltools.result.textOutputter")) {
                builtInOutputters.add(descriptor);
            }
            if (descriptor.getTypeId().equals("org.eclipse.datatools.sqltools.result.xmloutputter")) {
                builtInOutputters.add(descriptor);
            }
            if (descriptor.getTypeId().equals("org.eclipse.datatools.sqltools.result.htmloutputter")) {
                builtInOutputters.add(descriptor);
            }
            if (!descriptor.getTypeId().equals("org.eclipse.datatools.sqltools.result.csvoutputter")) continue;
            builtInOutputters.add(descriptor);
        }
        this._outputters.addAll(builtInOutputters);
        outputters.removeAll(builtInOutputters);
        this._outputters.addAll(outputters);
    }
}

