/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.utils;

import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.osgi.util.NLS;

public class StatusTextProvider {
    static String _LINESEPARATOR = System.getProperty("line.separator");

    public static String getUpdateCountText(int updateCount) {
        if (updateCount == 1) {
            return NLS.bind((String)Messages.StatusTextProvider_update_count_single, (Object[])new Object[]{String.valueOf(updateCount)}) + _LINESEPARATOR;
        }
        return NLS.bind((String)Messages.StatusTextProvider_update_count_complex, (Object[])new Object[]{String.valueOf(updateCount)}) + _LINESEPARATOR;
    }

    public static String getStatusText(IResultInstance instance) {
        StringBuffer buff = new StringBuffer("");
        buff.append(instance.getOperationCommand().getDisplayString()).append(_LINESEPARATOR).append(_LINESEPARATOR);
        int count = instance.getItemCount();
        for (int i = 0; i < count; ++i) {
            ResultItem item = instance.getItem(i);
            if (item.getResultType() == 4) {
                buff.append((String)item.getResultObject());
            }
            if (item.getResultType() != 1) continue;
            buff.append(StatusTextProvider.getUpdateCountText((Integer)item.getResultObject()));
        }
        return buff.toString();
    }

    public static String getHistoryHeader(IResultInstance instance) {
        StringBuffer buff = new StringBuffer("");
        buff.append(instance.getOperationCommand().getDisplayString()).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_action_type).append(OperationCommand.getActionString(instance.getOperationCommand().getActionType())).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_profile_name).append(instance.getOperationCommand().getProfileName()).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_database).append(instance.getOperationCommand().getDatabaseName()).append(_LINESEPARATOR);
        buff.append(Messages.StatusTextProvider_time).append(instance.getExecuteTime()).append(_LINESEPARATOR);
        int count = instance.getItemCount();
        for (int i = 0; i < count; ++i) {
            ResultItem item = instance.getItem(i);
            if (item.getResultType() != 4) continue;
            buff.append((String)item.getResultObject());
        }
        return buff.toString();
    }
}

