/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultHistoryHelper;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultsViewLabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            IResultInstance instance = (IResultInstance)element;
            int status = instance.getStatus();
            return OperationCommand.getStatusImage(status);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IResultInstance) {
            IResultInstance instance = (IResultInstance)element;
            int columnDisplayIndex = ResultHistoryHelper.getConfigurableColumnIndex(columnIndex);
            switch (columnDisplayIndex) {
                case 0: {
                    int status = instance.getStatus();
                    return OperationCommand.getStatusString(status);
                }
                case 1: {
                    return this.compact(instance.getOperationCommand());
                }
                case 2: {
                    return Integer.toString(instance.getFrequency());
                }
                case 3: {
                    return instance.getExecuteTime();
                }
                case 4: {
                    return OperationCommand.getActionString(instance.getOperationCommand().getActionType());
                }
                case 5: {
                    return instance.getOperationCommand().getConsumerName();
                }
                case 6: {
                    return instance.getOperationCommand().getProfileName();
                }
            }
            return "";
        }
        return Messages.ResultViewLabelProvider_unknown;
    }

    public String getConfigurableColumnText(Object element, int columnIndex) {
        if (element instanceof IResultInstance) {
            IResultInstance instance = (IResultInstance)element;
            switch (columnIndex) {
                case 0: {
                    int status = instance.getStatus();
                    return OperationCommand.getStatusString(status);
                }
                case 1: {
                    return this.compact(instance.getOperationCommand());
                }
                case 2: {
                    return Integer.toString(instance.getFrequency());
                }
                case 3: {
                    return instance.getExecuteTime();
                }
                case 4: {
                    return OperationCommand.getActionString(instance.getOperationCommand().getActionType());
                }
                case 5: {
                    return instance.getOperationCommand().getConsumerName();
                }
                case 6: {
                    return instance.getOperationCommand().getProfileName();
                }
            }
            return "";
        }
        return Messages.ResultViewLabelProvider_unknown;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected String compact(OperationCommand operation) {
        return operation.getDisplayString().replaceAll(System.getProperty("line.separator"), "  ");
    }
}

