/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export.component;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.export.IResultConstants;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EncodingDelimiterOptionsSection {
    Composite _parent;
    Group _exportFormatGroup;
    Combo _encodingCombo;
    Combo _delimiterCombo;
    Label _encodingLabel;
    Label _outputFormat;
    Label _delimiterLabel;
    Text _delimiterText;
    int _numColumns;
    IStatus _status;
    private Listener _listener;

    public EncodingDelimiterOptionsSection(Composite parent, int numColumns, Listener listener) {
        this._parent = parent;
        this._numColumns = numColumns;
        this._listener = listener;
        this.createControl(this._parent);
    }

    private void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = this._numColumns;
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.createExportControls(container);
        this.initializeValues();
    }

    private void createExportControls(Composite container) {
        this._exportFormatGroup = new Group(container, 16);
        this._exportFormatGroup.setText(Messages.ExportOptions_title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        this._exportFormatGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        this._exportFormatGroup.setLayoutData((Object)data);
        this._encodingLabel = new Label((Composite)this._exportFormatGroup, 0);
        this._encodingLabel.setText(Messages.ExportFormatPage_fileencoding_outputencoding);
        this._encodingLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this._encodingCombo = new Combo((Composite)this._exportFormatGroup, 0);
        this._encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EncodingDelimiterOptionsSection.this.updateValidState();
                EncodingDelimiterOptionsSection.this._listener.handleEvent(new Event());
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        this._encodingCombo.setLayoutData((Object)data);
        ArrayList encodings = this.getEncodings();
        for (int i = 0; i < encodings.size(); ++i) {
            this._encodingCombo.add(encodings.get(i).toString());
        }
        this._encodingCombo.select(0);
        this._outputFormat = new Label((Composite)this._exportFormatGroup, 0);
        this._outputFormat.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this._outputFormat.setText(Messages.ExportFormatPage_columndelimiter_outputformat);
        this._delimiterCombo = new Combo((Composite)this._exportFormatGroup, 8);
        this._delimiterCombo.setItems(IResultConstants.OUTPUT_FORMATS);
        this._delimiterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EncodingDelimiterOptionsSection.this.updateDelimter();
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        this._delimiterCombo.setLayoutData((Object)data);
        this._delimiterLabel = new Label((Composite)this._exportFormatGroup, 0);
        this._delimiterLabel.setText(Messages.ExportFormatPage_columndelimiter_delimiter);
        this._delimiterText = new Text((Composite)this._exportFormatGroup, 2048);
        GridData griddata1 = new GridData(768);
        this._delimiterText.setLayoutData((Object)griddata1);
    }

    private ArrayList getEncodings() {
        boolean isDefault;
        String enc;
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(Messages.ExportFormatPage_fileencoding_numDefaultEncodings);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < n; ++i) {
            enc = Messages.getString("ExportFormatPage_fileencoding_defaultEncoding" + (i + 1));
            if (enc == null) continue;
            encodings.add(enc);
        }
        String defaultEnc = System.getProperty("file.encoding", "UTF-8");
        if (!encodings.contains(defaultEnc)) {
            encodings.add(defaultEnc);
        }
        boolean bl = isDefault = (enc = ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.pref_encoding")) == null || enc.length() == 0;
        if (!isDefault && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        return encodings;
    }

    private void updateDelimter() {
        int delimiterIndex = this._delimiterCombo.getSelectionIndex();
        switch (delimiterIndex) {
            case 0: {
                this._delimiterText.setEditable(false);
                this._delimiterText.setText("<column>");
                break;
            }
            case 1: {
                this._delimiterText.setText(",");
                this._delimiterText.setEditable(false);
                break;
            }
            case 2: {
                this._delimiterText.setEditable(false);
                this._delimiterText.setText("<tab>");
                break;
            }
            case 3: {
                this._delimiterText.setEditable(true);
                this._delimiterText.setTextLimit(5);
                this._delimiterText.setText(ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.delimiter"));
                break;
            }
            default: {
                this._delimiterText.setEditable(true);
                this._delimiterText.setText("<column>");
            }
        }
    }

    private void initializeValues() {
        IPreferenceStore _store = ResultsViewPlugin.getDefault().getPreferenceStore();
        String prefEncoding = _store.getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.pref_encoding");
        int selected = this._encodingCombo.indexOf(prefEncoding);
        this._encodingCombo.select(selected);
        selected = _store.getInt("org.eclipse.datatools.sqltools.result.preferences.exportformat.outputformat");
        this._delimiterCombo.select(selected);
        this.updateDelimter();
    }

    public void updateTxtExportControls() {
        this._outputFormat.setEnabled(true);
        this._delimiterCombo.setEnabled(true);
        this._delimiterLabel.setEnabled(true);
        this._delimiterText.setEnabled(true);
    }

    public void updateXMLExportControls() {
        this._outputFormat.setEnabled(false);
        this._delimiterCombo.setEnabled(false);
        this._delimiterLabel.setEnabled(false);
        this._delimiterText.setEnabled(false);
    }

    public String getDelimiter() {
        return this._delimiterCombo.getItem(this._delimiterCombo.getSelectionIndex());
    }

    public String getUserDefinedDelimiter() {
        return this._delimiterText.getText().trim();
    }

    public String getEncoding() {
        return this._encodingCombo.getText();
    }

    public IStatus getStatus() {
        return this._status;
    }

    private void updateValidState() {
        this._status = !this.isEncodingValid() ? new Status(4, ResultsViewPlugin.getPluginId(), 0, Messages.ExportFormatPage_fileencoding_unsupportedEncoding, null) : Status.OK_STATUS;
    }

    private boolean isEncodingValid() {
        try {
            new String(new byte[0], this._encodingCombo.getText());
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }
}

