/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;

public abstract class AbstractOutputter {
    static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public abstract void output(IResultSetObject var1, Properties var2, OutputStream var3) throws IOException;

    public abstract void output(IResultSetObject var1, Properties var2, PrintWriter var3) throws IOException;

    public abstract void output(IResultInstance var1, Properties var2, OutputStream var3) throws IOException;

    public abstract void output(IResultInstance var1, Properties var2, PrintWriter var3) throws IOException;

    protected void writeStringData(PrintWriter w, String s) throws IOException {
        if (this.containsNonXMLChar(s)) {
            w.write("<![CDATA[");
            this.encodeCDATA(w, s.getBytes("UTF8"));
            w.write("]]>");
        } else {
            w.write(this.escapeForXML(s));
        }
    }

    protected void writeBinaryData(PrintWriter w, Object obj) throws IOException {
        if (obj instanceof byte[]) {
            w.write("<![CDATA[");
            this.encodeCDATA(w, (byte[])obj);
            w.write("]]>");
        }
    }

    private boolean containsNonXMLChar(String s) {
        boolean flag = false;
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            if (this.isXMLChar(s.charAt(i))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean isXMLChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd';
    }

    protected String escapeForXML(String s) {
        StringBuffer stringbuffer = new StringBuffer(s.length() + 16);
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                stringbuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringbuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringbuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringbuffer.append("&apos;");
                continue;
            }
            if (c == '\"') {
                stringbuffer.append("&quot;");
                continue;
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    private void encodeCDATA(PrintWriter w, byte[] bytes) throws IOException {
        int size = bytes.length;
        int i = 0;
        while (i < size) {
            int k = (bytes[i] & 0xF0) >> 4;
            w.write(hexTable[k]);
            k = bytes[i] & 0xF;
            w.write(hexTable[k]);
            if (++i % 32 != 0) continue;
            w.println();
        }
    }
}

