/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.core.ResultManager;
import org.eclipse.datatools.sqltools.result.internal.index.HistoryIndexListener;
import org.eclipse.datatools.sqltools.result.internal.index.IResultHistoryIndex;
import org.eclipse.datatools.sqltools.result.internal.index.ResultHistoryLuceneIndex;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusLogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ResultsViewPlugin
extends AbstractUIPlugin {
    private static ResultsViewPlugin plugin;
    private String _tempDir;
    private ResourceBundle _bundle = ResourceBundle.getBundle("org.eclipse.datatools.sqltools.result.internal.PluginResources");
    private IResultManager _resultManager;
    private IResultHistoryIndex _historyIndex;
    private static final String RESULTS_FILE_NAME = "results";
    private Color _disabledBakColor;

    public ResultsViewPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        String resultsStr;
        File resultsFile;
        super.start(context);
        if (this.getPreferenceStore().getBoolean("org.eclipse.datatools.sqltools.result.preferences.resulthistory.autosave") && (resultsFile = new File(resultsStr = ResultsViewPlugin.getDefault().getStateLocation().append(RESULTS_FILE_NAME).toOSString())).exists() && resultsFile.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(resultsFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                Object obj = ois.readObject();
                if (obj instanceof IResultManager) {
                    this._resultManager = (IResultManager)obj;
                }
            }
            catch (Exception e) {
                StatusLogger log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), "org.eclipse.datatools.sqltools.result", this._bundle);
                log.error("ResultsViewPlugin_load_history_error", (Throwable)e);
            }
        }
        this._historyIndex = new ResultHistoryLuceneIndex();
        if (this._resultManager != null) {
            this._historyIndex.addResults(this._resultManager.getAllResults());
            IResultInstance[] instances = this._resultManager.getAllResults();
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i].isFinished()) continue;
                instances[i].updateStatus(4);
            }
        }
        ResultsViewPlugin.getResultManager().addResultManagerListener(new HistoryIndexListener());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.getPreferenceStore().getBoolean("org.eclipse.datatools.sqltools.result.preferences.resulthistory.autosave") && this._resultManager != null) {
            String resultsStr = ResultsViewPlugin.getDefault().getStateLocation().append(RESULTS_FILE_NAME).toOSString();
            try {
                File resultsFile = new File(resultsStr);
                if (resultsFile.exists()) {
                    resultsFile.delete();
                }
                resultsFile.createNewFile();
                FileOutputStream fos = new FileOutputStream(resultsFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this._resultManager);
            }
            catch (Exception e) {
                StatusLogger log = new StatusLogger(ResultsViewPlugin.getDefault().getLog(), "org.eclipse.datatools.sqltools.result", this._bundle);
                log.error("ResultsViewPlugin_persist_history_error", (Throwable)e);
            }
        }
        if (this._disabledBakColor != null) {
            this._disabledBakColor.dispose();
        }
        plugin = null;
    }

    public static ResultsViewPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.datatools.sqltools.result", (String)path);
    }

    public String getTempDir() {
        if (this._tempDir == null) {
            this._tempDir = this.getStateLocation().append("temp").toOSString();
        }
        return this._tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IResultManager getResultManager() {
        ResultsViewPlugin resultsViewPlugin = ResultsViewPlugin.getDefault();
        synchronized (resultsViewPlugin) {
            if (ResultsViewPlugin.getDefault()._resultManager == null) {
                ResultsViewPlugin.getDefault()._resultManager = new ResultManager();
            }
            return ResultsViewPlugin.getDefault()._resultManager;
        }
    }

    public static ILogger getLogger(ResourceBundle bundle) {
        return new StatusLogger(ResultsViewPlugin.getDefault().getLog(), "org.eclipse.datatools.sqltools.result", bundle == null ? ResultsViewPlugin.getDefault()._bundle : bundle);
    }

    public static String getPluginId() {
        return ResultsViewPlugin.getDefault().getBundle().getSymbolicName();
    }

    public IResultHistoryIndex getResultHistoryIndex() {
        return this._historyIndex;
    }

    public synchronized Color getDisabledBakColor() {
        if (this._disabledBakColor == null) {
            this._disabledBakColor = new Color((Device)ResultsViewPlugin.getDefault().getWorkbench().getDisplay(), 238, 237, 224);
        }
        return this._disabledBakColor;
    }
}

