/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.ByteArrayInputStream;
import java.sql.ResultSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ResultsViewAPI {
    private static ResultsViewAPI _instance;
    private static ILogger _log;
    private IWorkbenchPage _activePage;
    private IResultManager _manager = ResultsViewPlugin.getResultManager();

    public static synchronized ResultsViewAPI getInstance() {
        if (_instance == null) {
            _instance = new ResultsViewAPI();
        }
        return _instance;
    }

    private ResultsViewAPI() {
    }

    public int getCurrentStatus(OperationCommand cmd) {
        if (cmd == null) {
            return -1;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            return instance.getStatus();
        }
        return -1;
    }

    public boolean appendPlainMessage(OperationCommand cmd, String message) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || message == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.morePlainMessage(message);
            return true;
        }
        return false;
    }

    public boolean appendResultSet(OperationCommand cmd, IResultSetObject rs) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || rs == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        try {
            if (instance != null) {
                if (instance.isFinished()) {
                    return false;
                }
                instance.moreResultSet(rs);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
            return false;
        }
    }

    public boolean appendResultSet(OperationCommand cmd, ResultSet rs) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || rs == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        try {
            if (instance != null) {
                if (instance.isFinished()) {
                    return false;
                }
                instance.moreResultSet(rs);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
            return false;
        }
    }

    public boolean appendStatusMessage(OperationCommand cmd, String message) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || message == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.moreStatusMessage(message);
            return true;
        }
        return false;
    }

    public boolean appendUpdateCountMessage(OperationCommand cmd, int count) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || count < 0) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            if (instance.isFinished()) {
                return false;
            }
            instance.moreUpdateCount(count);
            return true;
        }
        return false;
    }

    public boolean appendXMLResultSet(OperationCommand cmd, String xmlString) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || xmlString == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
        }
        catch (Exception dex) {
            _log.error("ResultsViewAPI_notwellformed_xml", (Throwable)dex);
            return false;
        }
        try {
            XMLResultSetObject rs = new XMLResultSetObject(xmlString);
            if (instance != null) {
                if (instance.isFinished()) {
                    return false;
                }
                instance.moreResultSet(rs);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            _log.error("ResultsViewAPI_append_resultset_error", (Throwable)e);
            return false;
        }
    }

    public boolean checkView() {
        int i;
        IWorkbenchWindow activeWindow = ResultsViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            IWorkbenchWindow[] windows = ResultsViewPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            for (i = 0; i < windows.length && (activeWindow = windows[0]) == null; ++i) {
            }
            if (activeWindow == null) {
                return false;
            }
        }
        this._activePage = activeWindow.getActivePage();
        if (this._activePage == null) {
            IWorkbenchPage[] pages = activeWindow.getPages();
            for (i = 0; i < pages.length; ++i) {
                this._activePage = pages[0];
                if (this._activePage != null) break;
            }
            if (this._activePage == null) {
                return false;
            }
        }
        activeWindow.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    ResultsViewAPI.this._activePage.showView("org.eclipse.datatools.sqltools.result.resultView");
                }
                catch (PartInitException ex) {
                    _log.error("ResultsViewAPI_checkview_error", (Throwable)ex);
                }
            }
        });
        return true;
    }

    public boolean createNewInstance(OperationCommand cmd, Runnable terminateHandler) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null) {
            return false;
        }
        if (cmd.getDisplayString() == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            return false;
        }
        instance = this._manager.createNewResultInstance(cmd, terminateHandler);
        return instance != null;
    }

    public boolean showParameters(OperationCommand cmd, List params) {
        if (!this.checkView()) {
            return false;
        }
        if (cmd == null || params == null) {
            return false;
        }
        IResultInstance instance = this._manager.getInstance(cmd);
        if (instance != null) {
            instance.showParameters(params);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(OperationCommand cmd, int status) {
        if (!this.checkView()) {
            return false;
        }
        OperationCommand operationCommand = cmd;
        synchronized (operationCommand) {
            if (cmd == null || status < 1 || status > 7) {
                return false;
            }
            IResultInstance instance = this._manager.getInstance(cmd);
            if (instance != null) {
                if (instance.isFinished()) {
                    return false;
                }
                if (instance.getStatus() == 2 && status == 1) {
                    return false;
                }
                instance.updateStatus(status);
                return true;
            }
            return false;
        }
    }

    static {
        _log = ResultsViewPlugin.getLogger(null);
    }
}

