/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.actions;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanServiceRegistry;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.Messages;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.SwitchPlanTypeAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.PlanView;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class PlanTypeDropDownAction
extends Action
implements IMenuCreator {
    private Menu _fMenu;
    private PlanView _planView;

    public PlanTypeDropDownAction(PlanView planView) {
        this.setText(Messages.PlanTypeDropDownAction_text);
        this.setToolTipText(Messages.PlanTypeDropDownAction_tooltip);
        this.setImageDescriptor(Images.DESC_PLAN_TYPE);
        this.setDisabledImageDescriptor(Images.DESC_PLAN_TYPE);
        this._planView = planView;
        this.setMenuCreator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"plan_type_drop_down_action", (String)PlanViewPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void dispose() {
        this.disposeMenu();
    }

    public void disposeMenu() {
        if (this._fMenu != null) {
            this._fMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        String dbDefinitionId = this._planView.getCurrentPlan().getPlanRequest().getDatabaseDefinitionId();
        IPlanService service = PlanServiceRegistry.getInstance().getPlanService(dbDefinitionId);
        String[] modeTypes = service.getPlanOption().getPlanTypes();
        this.disposeMenu();
        this._fMenu = new Menu(parent);
        int i = 0;
        while (i < modeTypes.length) {
            int modeType = service.getPlanOption().getTypeIdByName(modeTypes[i]);
            SwitchPlanTypeAction action = new SwitchPlanTypeAction(this._planView, modeType, modeTypes[i], null, "");
            if (this._planView.getCurrentPlan().getPlanRequest().getPlanType() == modeType) {
                action.setChecked(true);
            }
            this.addActionToMenu(this._fMenu, action);
            ++i;
        }
        return this._fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void update() {
        IPlanInstance plan = this._planView.getCurrentPlan();
        if (plan == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(PlanServiceRegistry.getInstance().getPlanService(this._planView.getCurrentPlan().getPlanRequest().getDatabaseDefinitionId()).getPlanOption().getPlanTypes().length != 0);
    }
}

