/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.plan.EPVFacade;
import org.eclipse.datatools.sqltools.plan.Messages;
import org.eclipse.datatools.sqltools.plan.PlanRequest;

public abstract class PlanSupportRunnable
extends Job {
    protected PlanRequest _request;
    protected Connection _conn;
    protected String _rawPlanString;
    protected Statement _stmt;
    protected String _profileName;
    protected String _dbName;
    protected boolean _needReleaseConn = true;

    public PlanSupportRunnable() {
        super(Messages.PlanSupportRunnable_getplan_name);
    }

    public PlanSupportRunnable(PlanRequest request, String profileName, String dbName) {
        super(Messages.PlanSupportRunnable_getplan_name);
        this._request = request;
        this._profileName = profileName;
        this._dbName = dbName;
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    protected abstract String explainPlan(Statement var1) throws SQLException;

    protected String getPlan() {
        return this._rawPlanString;
    }

    protected void handleSuccess() {
        EPVFacade.getInstance().planGenerated(this._request, this.getPlan());
    }

    protected void handleEnd(Connection connection, Statement stmt) {
        if (!this._needReleaseConn) {
            return;
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    protected String retrievePlan(ResultSet rs, int columnIndex) throws SQLException {
        String plan = null;
        if (rs.next()) {
            plan = rs.getString(columnIndex);
        }
        rs.close();
        return plan;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
        this._needReleaseConn = false;
    }

    public PlanRequest getRequest() {
        return this._request;
    }

    public void setRequest(PlanRequest _request) {
        this._request = _request;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        boolean insCreated;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(insCreated = EPVFacade.getInstance().createNewPlanInstance(this.getRequest()))) {
            this.handleEnd(this._conn, this._stmt);
            return Status.CANCEL_STATUS;
        }
        try {
            try {
                this.prepareConnection();
                this._stmt = this.prepareStatement(this._conn);
                this._rawPlanString = this.explainPlan(this._stmt);
                this.handleSuccess();
            }
            catch (SQLException ex) {
                EPVFacade.getInstance().planFailed(this.getRequest(), ex);
            }
            catch (Throwable th) {
                EPVFacade.getInstance().planFailed(this.getRequest(), th);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.handleEnd(this._conn, this._stmt);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.handleEnd(this._conn, this._stmt);
            return Status.OK_STATUS;
        }
    }

    protected void prepareConnection() {
    }
}

