/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.Messages;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PlansDialog
extends SelectionDialog {
    private static final int _REMOVE_ID = 1025;
    private static final int _WIDTH_IN_CHARACTERS = 55;
    private List _fInput;
    private TableViewer _fViewer;

    public PlansDialog(Shell parent, List input) {
        super(parent);
        this.setTitle(Messages.getString("PlansDialog.title"));
        this.setMessage(Messages.getString("PlansDialog.message"));
        this._fInput = input;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(this.getMessage());
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        label.setLayoutData((Object)gd);
        PlansDialog.applyDialogFont((Control)label);
        return label;
    }

    protected Control createDialogArea(Composite container) {
        Composite ancestor = (Composite)super.createDialogArea(container);
        this.createMessageArea(ancestor);
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this._fViewer = new TableViewer(parent, 68356);
        this._fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this._fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PlansDialog.this.getButton(1025).setEnabled(!event.getSelection().isEmpty());
            }
        });
        Table table = this._fViewer.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                PlansDialog.this.okPressed();
            }
        });
        this._fViewer.setLabelProvider((IBaseLabelProvider)new PlansLabelProvider());
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        table.setLayoutData((Object)gd);
        Button button = this.createButton(parent, 1025, Messages.getString("PlansDialog.remove"), false);
        ((GridData)button.getLayoutData()).verticalAlignment = 1;
        PlansDialog.applyDialogFont((Control)ancestor);
        this._fViewer.setInput((Object)this._fInput);
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this._fViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        return table;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            IStructuredSelection selection = (IStructuredSelection)this._fViewer.getSelection();
            Iterator instances = selection.iterator();
            while (instances.hasNext()) {
                IPlanInstance inst = (IPlanInstance)instances.next();
                PlanViewPlugin.getPlanManager().removePlanInstance(inst);
                this._fInput.remove(inst);
            }
            this._fViewer.refresh();
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        ISelection selection = this._fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setResult(((IStructuredSelection)this._fViewer.getSelection()).toList());
        }
        super.okPressed();
    }

    private static final class PlansLabelProvider
    extends LabelProvider {
        private ArrayList _fImages = new ArrayList();

        private PlansLabelProvider() {
        }

        public String getText(Object element) {
            String label = ((IPlanInstance)element).getPlanRequest().getDatabaseDefinitionId() + ": " + ((IPlanInstance)element).getPlanRequest().getSql();
            if (label.length() > 55) {
                label = label.substring(0, 52) + " ...";
            }
            return label;
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = Images.DESC_SHOWPLAN;
            if (imageDescriptor == null) {
                return null;
            }
            Image image = imageDescriptor.createImage();
            this._fImages.add(image);
            return image;
        }

        public void dispose() {
            Iterator iter = this._fImages.iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
            this._fImages = null;
        }
    }
}

