/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileProxyListener;
import org.eclipse.datatools.sqltools.internal.core.ControlConnectionManager;
import org.eclipse.datatools.sqltools.internal.core.IConfigurationRegistryListener;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistry;
import org.eclipse.datatools.sqltools.internal.core.SQLDevToolsConfigRegistryImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EditorCorePlugin
extends AbstractUIPlugin {
    private static final int INTERNAL_ERROR = 0;
    public static final String PLUGIN_ID = "org.eclipse.datatools.sqltools.editor.core";
    private static EditorCorePlugin plugin;
    private IControlConnectionManager _controlConnectionManager;
    boolean _registered = false;

    public EditorCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        EditorCorePlugin.addConfigurationRegistryListener(new IConfigurationRegistryListener(){

            public void configurationLoaded() {
                EditorCorePlugin.this.register();
            }
        });
    }

    private synchronized void register() {
        if (!this._registered) {
            ProfileManager pManager = ProfileManager.getInstance();
            IConnectionProfile[] profiles = ProfileUtil.getProfiles();
            SQLToolsProfileProxyListener listener = SQLToolsProfileProxyListener.getInstance();
            listener.init(profiles);
            pManager.addProfileListener((IProfileListener)listener);
            this._registered = true;
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this._controlConnectionManager == null) {
            RefreshManager.getInstance().removeListener(null, (ICatalogObjectListener)this._controlConnectionManager);
        }
        super.stop(context);
        plugin = null;
    }

    public static EditorCorePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static synchronized IControlConnectionManager getControlConnectionManager() {
        if (EditorCorePlugin.getDefault()._controlConnectionManager == null) {
            ControlConnectionManager controlConnectionManager = new ControlConnectionManager();
            EditorCorePlugin.getDefault()._controlConnectionManager = controlConnectionManager;
            RefreshManager.getInstance().AddListener(null, (ICatalogObjectListener)controlConnectionManager);
        }
        return EditorCorePlugin.getDefault()._controlConnectionManager;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, Messages.plugin_internal_error, e);
    }

    public IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, this.getBundle().getSymbolicName(), 0, message, e);
    }

    public void log(String message, Throwable e) {
        this.log(this.createErrorStatus(message, e));
    }

    public static SQLDevToolsConfigRegistry getDatabaseFactoryRegistry() {
        return SQLDevToolsConfigRegistryImpl.INSTANCE;
    }

    public static void addConfigurationRegistryListener(IConfigurationRegistryListener listener) {
        EditorCorePlugin.getDatabaseFactoryRegistry().addConfigurationRegistryListener(listener);
    }
}

