/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class ParameterUtil {
    public static Map getSPParamDefaultValues(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap params = ParameterUtil.getSPParams(databaseIdentifier, sp);
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String name = (String)iter.next();
            IASTSQLParam param = (IASTSQLParam)params.get(name);
            if (param.getDefaultValue() == null || (value = param.getDefaultValue()) != null && value.equalsIgnoreCase("null")) continue;
            map.put(name, value);
        }
        return map;
    }

    public static Map getSPParamTypeNameMapFromParser(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap params = ParameterUtil.getSPParams(databaseIdentifier, sp);
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            IASTSQLParam param = (IASTSQLParam)params.get(name);
            String type = param.getType();
            map.put(name, type);
        }
        return map;
    }

    public static HashMap getSPParams(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap map = new HashMap();
        SQLParser parser = SQLToolsFacade.getSQLParser(databaseIdentifier.getProfileName(), "");
        Document doc = new Document(sp);
        ParsingResult result = parser.parse(sp, new ParserParameters(false));
        HashMap params = result.getParameters((IDocument)doc, doc.getLength() - 1);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParameterDescriptor[] getParameterDescriptors(DatabaseIdentifier databaseIdentifier, Connection connection, int type, ProcIdentifier proc) throws SQLException {
        ParameterDescriptor[] parameterDescriptorArray;
        block18: {
            DatabaseMetaData md = null;
            ResultSet rs = null;
            try {
                ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
                md = connection.getMetaData();
                String dbname = proc.getDatabaseIdentifier().getDBname();
                if (dbname != null && dbname.length() == 0) {
                    dbname = null;
                }
                rs = md.getProcedureColumns(dbname, proc.getOwnerName(), proc.getProcName(), "%");
                while (rs.next()) {
                    String name = rs.getString(4);
                    short parmType = rs.getShort(5);
                    int sqlDataType = rs.getShort(6);
                    String dataTypeName = rs.getString(7);
                    if (dataTypeName.equalsIgnoreCase("double") && sqlDataType == 0) {
                        sqlDataType = 8;
                    }
                    int precision = rs.getInt(8);
                    int length = rs.getInt(9);
                    short scale = rs.getShort(10);
                    short radix = rs.getShort(11);
                    short nullable = rs.getShort(12);
                    String comment = rs.getString(13);
                    switch (sqlDataType) {
                        case 2: 
                        case 3: {
                            if ("money".equalsIgnoreCase(dataTypeName) || "smallmoney".equalsIgnoreCase(dataTypeName)) break;
                            dataTypeName = dataTypeName + "(" + precision + "," + scale + ")";
                            break;
                        }
                        case -3: 
                        case -2: 
                        case 1: 
                        case 6: 
                        case 12: {
                            dataTypeName = dataTypeName + "(" + precision + ")";
                        }
                    }
                    ParameterDescriptor p = new ParameterDescriptor(databaseIdentifier, name, parmType, sqlDataType, precision, scale, dataTypeName, nullable, comment);
                    parameters.add(p);
                }
                parameterDescriptorArray = parameters.toArray(new ParameterDescriptor[0]);
                Object var20_19 = null;
                if (rs == null) break block18;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                    }
                    finally {
                        rs = null;
                    }
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
            }
            finally {
                rs = null;
            }
        }
        return parameterDescriptorArray;
    }
}

