/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.refresh.ICatalogObject2;
import org.eclipse.datatools.sqltools.sql.reference.IDatatype;
import org.eclipse.datatools.sqltools.sql.reference.internal.Datatype;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ModelUtil {
    public static final String EVENT_FOLDER_CLASS = "DBEventsFolder";

    public static IDatatype map(DatabaseDefinition databaseDefinition, DataType type, String owner) {
        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(type.getName());
        if (type instanceof PredefinedDataType) {
            return ModelUtil.createIDatatype(typeDefinition, (PredefinedDataType)type, owner);
        }
        if (type instanceof DistinctUserDefinedType) {
            PredefinedDataType pretype = ((DistinctUserDefinedType)type).getPredefinedRepresentation();
            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(pretype.getName());
            IDatatype datatype = ModelUtil.createIDatatype(typeDefinition, pretype, owner);
            return new Datatype(owner, type.getName(), true, datatype, datatype.getLength(), datatype.getPrecision(), datatype.getScale(), datatype.allowNull());
        }
        return null;
    }

    private static IDatatype createIDatatype(PredefinedDataTypeDefinition typeDefinition, PredefinedDataType type, String owner) {
        Datatype datatype = null;
        int length = 0;
        int precision = 0;
        int scale = 0;
        boolean nullable = true;
        if (typeDefinition != null) {
            EStructuralFeature feature;
            if (typeDefinition.isLengthSupported()) {
                feature = type.eClass().getEStructuralFeature("length");
                length = (Integer)type.eGet(feature);
            } else if (typeDefinition.isPrecisionSupported()) {
                feature = type.eClass().getEStructuralFeature("precision");
                precision = (Integer)type.eGet(feature);
            }
            if (typeDefinition.isScaleSupported()) {
                feature = type.eClass().getEStructuralFeature("scale");
                scale = (Integer)type.eGet(feature);
            }
            if (typeDefinition.isNullableSupported() && (feature = type.eClass().getEStructuralFeature("nullable")) != null) {
                nullable = (Boolean)type.eGet(feature);
            }
            datatype = new Datatype(owner, type.getName(), false, null, length, precision, scale, nullable);
        }
        return datatype;
    }

    public static SQLObject findProceduralObject(ProcIdentifier proc) {
        return ModelUtil.findProceduralObject(proc, false);
    }

    public static Database getDatabase(Schema schema) {
        Catalog catalog = schema.getCatalog();
        if (catalog != null) {
            return catalog.getDatabase();
        }
        return schema.getDatabase();
    }

    public static String getDatabaseName(EObject obj) {
        EObject container = obj;
        while (container != null) {
            obj = container;
            if (obj instanceof Catalog && ((Catalog)obj).getName() != null && !"".equals(((Catalog)obj).getName())) {
                return ((Catalog)obj).getName();
            }
            if (obj instanceof Database) {
                return ((Database)obj).getName();
            }
            container = ContainmentServiceImpl.INSTANCE.getContainer(obj);
        }
        return null;
    }

    public static Catalog getCatalog(EObject obj) {
        EObject container = obj;
        while (container != null) {
            obj = container;
            if (obj instanceof Catalog) {
                return (Catalog)obj;
            }
            container = ContainmentServiceImpl.INSTANCE.getContainer(obj);
        }
        return null;
    }

    public static String getSchemaName(EObject obj) {
        Schema schema = ModelUtil.getSchema(obj);
        if (schema != null) {
            return schema.getName();
        }
        return null;
    }

    public static Schema getSchema(EObject obj) {
        if (obj instanceof Trigger) {
            return ((Trigger)obj).getSchema();
        }
        EObject container = obj;
        while (container != null) {
            obj = container;
            if (obj instanceof Schema) {
                return (Schema)obj;
            }
            container = ContainmentServiceImpl.INSTANCE.getContainer(obj);
        }
        return null;
    }

    public static IConnectionProfile getConnectionProfile(Database database) {
        ConnectionInfo connInfo;
        if (database != null && (connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database)) instanceof ConnectionInfoImpl) {
            return ((ConnectionInfoImpl)connInfo).getConnectionProfile();
        }
        return null;
    }

    public static EList getSchemas(Database database, String catalogName) {
        EList catalogs;
        EList schemas;
        if (catalogName == null || catalogName.equals("")) {
            catalogName = database.getName();
        }
        if (((schemas = database.getSchemas()) == null || schemas.size() == 0) && (catalogs = database.getCatalogs()) != null) {
            Iterator iter = catalogs.iterator();
            while (iter.hasNext()) {
                Catalog catalog = (Catalog)iter.next();
                if (!catalog.getName().equals(catalogName) && !catalog.getName().equals("")) continue;
                schemas = catalog.getSchemas();
                break;
            }
        }
        return schemas;
    }

    public static Schema findSchema(Database database, String catalogName, String schemaName) {
        EList schemas = ModelUtil.getSchemas(database, catalogName);
        Iterator it = schemas.iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            if (!schema.getName().equals(schemaName)) continue;
            return schema;
        }
        return null;
    }

    public static DatabaseDefinition getDatabaseDefinition(SQLObject obj) {
        EObject database = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)obj);
        DatabaseDefinition dbdef = null;
        if (database instanceof Database) {
            dbdef = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)database);
        }
        return dbdef;
    }

    public static DatabaseVendorDefinitionId getDatabaseVendorDefinitionId(SQLObject obj) {
        DatabaseVendorDefinitionId dbid = SQLDevToolsConfiguration.getDefaultInstance().getDatabaseVendorDefinitionId();
        DatabaseDefinition dbdef = ModelUtil.getDatabaseDefinition(obj);
        if (dbdef != null) {
            dbid = new DatabaseVendorDefinitionId(dbdef.getProduct(), dbdef.getVersion());
        }
        return dbid;
    }

    public static List getAuthorizationIdentifiers(SQLObject obj) {
        EObject db;
        EStructuralFeature feature;
        Catalog catalog = ModelUtil.getCatalog((EObject)obj);
        List authIds = null;
        if (catalog != null && (feature = catalog.eClass().getEStructuralFeature("authorizationIds")) != null) {
            authIds = (List)catalog.eGet(feature);
        }
        if ((authIds == null || authIds.isEmpty()) && (db = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)obj)) instanceof Database) {
            authIds = ((Database)db).getAuthorizationIds();
        }
        return authIds;
    }

    public static Table findTableObject(DatabaseIdentifier dbid, String dbname, String schemaName, String tableName) {
        return ModelUtil.findTableObject(dbid, dbname, schemaName, tableName, false);
    }

    public static Table findTableObject(DatabaseIdentifier dbid, String dbname, String schemaName, String tableName, boolean refresh) {
        return ModelUtil.findTableObject(dbid, dbname, schemaName, tableName, refresh, true);
    }

    public static Table findTableObject(DatabaseIdentifier dbid, String dbname, String schemaName, String tableName, boolean refresh, boolean caseSensitive) {
        return ModelUtil.findTableObject(dbid, dbname, schemaName, tableName, refresh, caseSensitive, true);
    }

    public static Table findTableObject(DatabaseIdentifier dbid, String dbname, String schemaName, String tableName, boolean refresh, boolean caseSensitive, boolean findInAllCatalogs) {
        Table tableObject;
        block4: {
            Catalog catalog;
            Iterator iter;
            EList catalogs;
            EList schemas;
            Database db = ProfileUtil.getDatabase(dbid);
            tableObject = null;
            if (db != null) {
                schemas = db.getSchemas();
                if ((schemas == null || schemas.size() == 0) && (catalogs = db.getCatalogs()) != null) {
                    iter = catalogs.iterator();
                    while (iter.hasNext()) {
                        catalog = (Catalog)iter.next();
                        if (!ModelUtil.equals(catalog.getName(), dbname, caseSensitive)) continue;
                        schemas = catalog.getSchemas();
                        break;
                    }
                }
                tableObject = ModelUtil.findTableFromSchema(schemas, schemaName, tableName, caseSensitive, refresh);
            }
            if (!findInAllCatalogs || tableObject != null || (schemas = db.getSchemas()) == null && schemas.size() == 0 || (catalogs = db.getCatalogs()) == null) break block4;
            iter = catalogs.iterator();
            while (iter.hasNext() && (ModelUtil.equals((catalog = (Catalog)iter.next()).getName(), dbname, caseSensitive) || (tableObject = ModelUtil.findTableFromSchema(schemas = catalog.getSchemas(), schemaName, tableName, caseSensitive, refresh)) == null)) {
            }
        }
        return tableObject;
    }

    private static Table findTableFromSchema(EList schemas, String schemaName, String tableName, boolean caseSensitive, boolean refresh) {
        Table tableObject = null;
        Iterator i = schemas.iterator();
        while (i.hasNext() && tableName != null && !tableName.equals("")) {
            Schema schema = (Schema)i.next();
            if (schema.getName() == null || !ModelUtil.equals(schema.getName(), schemaName, caseSensitive)) continue;
            if (refresh) {
                if (schema instanceof ICatalogObject2) {
                    String context = ((ICatalogObject2)schema).getRefreshContext(new Integer(9));
                    ((ICatalogObject2)schema).refresh(context);
                } else {
                    ((ICatalogObject)schema).refresh();
                }
            }
            Iterator iter = schema.getTables().iterator();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!ModelUtil.equals(table.getName(), tableName, caseSensitive)) continue;
                tableObject = table;
            }
        }
        return tableObject;
    }

    public static SQLObject findProceduralObject(ProcIdentifier proc, boolean refresh) {
        return ModelUtil.findProceduralObject(proc, refresh, true);
    }

    public static SQLObject findProceduralObject(ProcIdentifier proc, boolean refresh, boolean caseSensitive) {
        return ModelUtil.findProceduralObject(proc, refresh, caseSensitive, false);
    }

    public static SQLObject findProceduralObject(ProcIdentifier proc, boolean refresh, boolean caseSensitive, boolean ignoreTableName) {
        SQLObject object = null;
        Database db = ProfileUtil.getDatabase(proc.getDatabaseIdentifier());
        if (db != null) {
            if (proc.getType() == 2) {
                if (refresh) {
                    if (db instanceof ICatalogObject2) {
                        String context = ((ICatalogObject2)db).getRefreshContext(new Integer(10));
                        ((ICatalogObject2)db).refresh(context);
                    } else {
                        ((ICatalogObject)db).refresh();
                    }
                }
                EList events = db.getEvents();
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    Event routine = (Event)iter.next();
                    if (!ModelUtil.equals(routine.getName(), proc.getProcName(), caseSensitive)) continue;
                    object = routine;
                }
            } else {
                EList schemas = ModelUtil.getSchemas(db, proc.getDatabaseName());
                object = ModelUtil.findProceduralObjectFromSchema(schemas, proc, caseSensitive, refresh, ignoreTableName);
            }
        }
        return object;
    }

    private static SQLObject findProceduralObjectFromSchema(EList schemas, ProcIdentifier proc, boolean caseSensitive, boolean refresh, boolean ignoreTableName) {
        Routine object = null;
        String owner = proc.getOwnerName();
        if (proc.getType() == 3 && proc.getTableOwnerName() != null) {
            owner = proc.getTableOwnerName();
        }
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            Iterator iter;
            Schema schema = (Schema)i.next();
            if (schema.getName() == null || !ModelUtil.equals(schema.getName(), owner, caseSensitive)) continue;
            if (proc.getType() == 3) {
                EList tables = schema.getTables();
                iter = tables.iterator();
                while (iter.hasNext()) {
                    Table table = (Table)iter.next();
                    if (!ignoreTableName && !ModelUtil.equals(table.getName(), proc.getTableName(), caseSensitive)) continue;
                    if (refresh && table instanceof ICatalogObject) {
                        if (table instanceof ICatalogObject2) {
                            String context = ((ICatalogObject2)table).getRefreshContext(new Integer(12));
                            ((ICatalogObject2)table).refresh(context);
                        } else {
                            ((ICatalogObject)table).refresh();
                        }
                    }
                    EList triggers = table.getTriggers();
                    Iterator itera = triggers.iterator();
                    while (itera.hasNext()) {
                        Trigger trigger = (Trigger)itera.next();
                        if (!ignoreTableName && !ModelUtil.equals(table.getName(), proc.getTableName(), caseSensitive) || !ModelUtil.equals(trigger.getName(), proc.getProcName(), caseSensitive)) continue;
                        object = trigger;
                        return object;
                    }
                }
                continue;
            }
            if (proc.getType() != 1 && proc.getType() != 0) continue;
            if (refresh) {
                if (schema instanceof ICatalogObject2) {
                    String context = ((ICatalogObject2)schema).getRefreshContext(new Integer(16));
                    ((ICatalogObject2)schema).refresh(context);
                } else {
                    ((ICatalogObject)schema).refresh();
                }
            }
            EList routines = schema.getRoutines();
            iter = routines.iterator();
            while (iter.hasNext()) {
                Routine routine = (Routine)iter.next();
                if (!ModelUtil.equals(routine.getName(), proc.getProcName(), caseSensitive)) continue;
                object = routine;
                return object;
            }
        }
        return object;
    }

    public static boolean equals(String object1, String object2, boolean caseSensitive) {
        if (caseSensitive) {
            return object1.equals(object2);
        }
        return object1.equalsIgnoreCase(object2);
    }
}

