/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.util;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.ActionService;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.sql.util.Messages;

public class DSEUtil {
    public static String getProfileName(IVirtualNode _node) {
        ConnectionInfo conInfo = _node.getParentConnection();
        Object parent = _node.getParent();
        if (!(conInfo instanceof ConnectionInfoImpl) && parent instanceof ICatalogObject) {
            Database db = ((ICatalogObject)parent).getCatalogDatabase();
            conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(db);
            if (conInfo == null) {
                EditorCorePlugin.getDefault().log(Messages.error_cannot_get_connection_profile);
                return null;
            }
        }
        String profileName = ((ConnectionInfoImpl)conInfo).getConnectionProfile().getName();
        return profileName;
    }

    public static void refreshParent(SQLObject element) {
        Table parent = null;
        if (element instanceof Trigger) {
            parent = ((Trigger)element).getSubjectTable();
        } else if (element instanceof Routine) {
            parent = ((Routine)element).getSchema();
        } else if (element instanceof Event) {
            parent = ((Event)element).getDatabase();
        }
        if (parent instanceof ICatalogObject) {
            ((ICatalogObject)parent).refresh();
        }
    }

    public static ActionService getActionService(SQLObject object) {
        ProcIdentifier procIdentifier = SQLDevToolsUtil.getProcIdentifier(object);
        return DSEUtil.getActionService(procIdentifier.getProfileName());
    }

    public static ActionService getActionService(IVirtualNode node) {
        String profileName = ((ConnectionInfoImpl)node.getParentConnection()).getConnectionProfile().getName();
        return DSEUtil.getActionService(profileName);
    }

    public static ActionService getActionService(String profileName) {
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName(profileName);
        return conf.getActionService();
    }

    public static ActionService getActionService(DatabaseVendorDefinitionId vendorId) {
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByVendorIdentifier(vendorId);
        return conf.getActionService();
    }
}

