/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.updater;

import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;

public abstract class ProceduralObjectSourceUpdater {
    protected DatabaseDefinition _dbDefinition;
    protected DatabaseVendorDefinitionId _dbDefinitionId;
    protected SQLParser _parser;
    protected SQLObject _routine = null;
    protected ParserParameters _parserParameters;
    protected boolean _testMode = false;

    public ProceduralObjectSourceUpdater(SQLObject _object, DatabaseDefinition dbDefinition) {
        this._routine = _object;
        this._dbDefinition = dbDefinition;
        this._dbDefinitionId = new DatabaseVendorDefinitionId(this._dbDefinition.getProduct(), this._dbDefinition.getVersion());
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByVendorIdentifier(this._dbDefinitionId);
        this._parser = f.getSQLService().getSQLParser();
        this._parserParameters = new ParserParameters(false);
        this._parserParameters.setProperty((Object)"__header_mode", (Object)Boolean.TRUE);
    }

    public boolean updateName(String newName) {
        String body = this.getBody();
        ParsingResult result = this._parser.parse(body, this._parserParameters);
        IASTStart root = result.getRootNode();
        for (int i = 0; i < root.jjtGetNumChildren(); ++i) {
            Node node = root.jjtGetChild(i);
            if (!(node instanceof IASTDeployable)) continue;
            Node nameNode = ((IASTDeployable)node).getNameNode();
            Token nameToken = nameNode.getLastToken();
            int[] range = this._parser.getRange(nameToken);
            body = body.substring(0, range[0]) + newName + body.substring(range[1]);
            this.setBody(body);
            return true;
        }
        return false;
    }

    public abstract String getBody();

    public abstract void setBody(String var1);

    public void setTestMode(boolean testMode) {
        this._testMode = testMode;
    }

    public boolean getTestMode() {
        return this._testMode;
    }
}

